/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestItemModelsCollection;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddProcessItemCoreTests
extends RestTest {
    private FileModel document;
    private FileModel document2;
    private SiteModel siteModel;
    private UserModel userWhoStartsProcess;
    private UserModel assignee;
    private UserModel adminUser;
    private UserModel anotherUser;
    private RestProcessModel processModel;
    private RestItemModel processItem;
    private RestItemModelsCollection processItems;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.document2 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsProcess)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add process item using by the user who started the process.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addProcessItemByUserThatStartedTheProcess() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processItem = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.processItem.assertThat().field("createdAt").isNotEmpty()).and().field("size").is((Object)"19")).and().field("createdBy").is((Object)this.adminUser.getUsername())).and().field("modifiedAt").isNotEmpty()).and().field("name").is((Object)this.document.getName())).and().field("modifiedBy").is((Object)this.userWhoStartsProcess.getUsername())).and().field("id").isNotEmpty()).and().field("mimeType").is((Object)this.document.getFileType().mimeType);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add multiple process items using by the user who started the process.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addMultipleProcessItemsByUserThatStartedTheProcess() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processItems = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItems(new FileModel[]{this.document, this.document2});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.processItems.getEntries().get(0)).onModel().assertThat().field("createdAt").isNotEmpty()).and().field("size").is((Object)"19")).and().field("createdBy").is((Object)this.adminUser.getUsername())).and().field("modifiedAt").isNotEmpty()).and().field("name").is((Object)this.document.getName())).and().field("modifiedBy").is((Object)this.userWhoStartsProcess.getUsername())).and().field("id").isNotEmpty()).and().field("mimeType").is((Object)this.document.getFileType().mimeType);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.processItems.getEntries().get(1)).onModel().assertThat().field("createdAt").isNotEmpty()).and().field("size").is((Object)"19")).and().field("createdBy").is((Object)this.adminUser.getUsername())).and().field("modifiedAt").isNotEmpty()).and().field("name").is((Object)this.document2.getName())).and().field("modifiedBy").is((Object)this.userWhoStartsProcess.getUsername())).and().field("id").isNotEmpty()).and().field("mimeType").is((Object)this.document2.getFileType().mimeType);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add process item by a random user.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addProcessItemByAnyUser() throws Exception {
        this.anotherUser = this.dataUser.createRandomTestUser();
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"maxItems=1"}).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processItem = this.restClient.authenticateUser(this.anotherUser).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(String.format(RestErrorModel.ACCESS_INFORMATION_NOT_ALLOWED, this.processModel.getId()));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add multiple process item by a random user.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addMultipleProcessItemByAnyUser() throws Exception {
        this.anotherUser = this.dataUser.createRandomTestUser();
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"maxItems=1"}).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processItems = this.restClient.authenticateUser(this.anotherUser).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItems(new FileModel[]{this.document2, this.document});
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(String.format(RestErrorModel.ACCESS_INFORMATION_NOT_ALLOWED, this.processModel.getId()));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process item is falling in case of invalid process id is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessItemIfInvalidProcessIdIsProvided() throws Exception {
        RestProcessModelsCollection processes = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"maxItems=1"}).withWorkflowAPI().getProcesses();
        this.processModel = ((RestProcessModel)((RestProcessModelsCollection)((RestModels)processes.assertThat().entriesListIsNotEmpty()).when()).getOneRandomEntry()).onModel();
        FileModel testDocument = ((DataContent)this.dataContent.usingAdmin().usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.processModel.setId("invalidProcessId");
        this.processItem = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(testDocument);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidProcessId"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple process items is falling in case of invalid process id is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingMultipleProcessItemsIfInvalidProcessIdIsProvided() throws Exception {
        RestProcessModelsCollection processes = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"maxItems=1"}).withWorkflowAPI().getProcesses();
        this.processModel = ((RestProcessModel)((RestProcessModelsCollection)((RestModels)processes.assertThat().entriesListIsNotEmpty()).when()).getOneRandomEntry()).onModel();
        FileModel testDocument = ((DataContent)this.dataContent.usingAdmin().usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.processModel.setId("invalidProcessId");
        this.processItems = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItems(new FileModel[]{testDocument, this.document});
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidProcessId"));
    }

    @Bug(id="REPO-1937")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process item is falling in case of invalid body item is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessItemIfInvalidItemBodyIsProvided() throws Exception {
        this.document.setNodeRef("invalidNodeRef");
        this.processItem = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidId"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple process items is falling in case of empty body item value is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingMultipleProcessItemIfEmptyItemBodyIsProvided() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.document.setNodeRef("");
        this.processItems = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItems(new FileModel[]{this.document, this.document2});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.REQUIRED_TO_ADD, "itemId"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process item is falling in case of incomplete body (empty) is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessItemIfIncompleteBodyIsProvided() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"{}", (String)"processes/{processId}/items", (String[])new String[]{this.processModel.getId()});
        this.restClient.processModel(RestItemModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.REQUIRED_TO_ADD, "itemId"));
    }
}

