/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestActionConstraintModel;
import org.alfresco.rest.model.RestActionDefinitionModel;
import org.alfresco.rest.model.RestActionDefinitionModelsCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.utility.model.RepoTestModel;
import org.json.JSONObject;
import org.springframework.http.HttpMethod;

public class Actions
extends ModelRequest<Actions> {
    public Actions(RestWrapper restWrapper) {
        super(restWrapper);
    }

    public RestActionDefinitionModelsCollection listActionDefinitions() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "action-definitions?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestActionDefinitionModelsCollection.class, request);
    }

    public JSONObject executeAction(String actionDefinitionId, RepoTestModel targetNode, Map<String, Serializable> params) {
        String postBody = JsonBodyGenerator.executeActionPostBody(actionDefinitionId, targetNode, params);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "action-executions", new String[0]);
        return this.restWrapper.processJson(request);
    }

    public JSONObject executeAction(String actionDefinitionId, RepoTestModel targetNode) {
        String postBody = JsonBodyGenerator.executeActionPostBody(actionDefinitionId, targetNode);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "action-executions", new String[0]);
        return this.restWrapper.processJson(request);
    }

    public RestActionDefinitionModel getActionDefinitionById(String actionDefinitionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "action-definitions/".concat(actionDefinitionId), new String[0]);
        return this.restWrapper.processModel(RestActionDefinitionModel.class, request);
    }

    public RestActionConstraintModel getActionConstraintByName(String actionConstraintName) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "action-parameter-constraints/".concat(actionConstraintName), new String[0]);
        return this.restWrapper.processModel(RestActionConstraintModel.class, request);
    }
}

