/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processDefinitions;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessDefinitionStartFormModelSanityTests
extends RestTest {
    private UserModel adminUserModel;
    private RestProcessDefinitionModel randomProcessDefinition;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(this.adminUserModel);
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.SANITY}, description="Verify Admin gets a model of the start form type definition for non-network deployments using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "process-definitions", "sanity"})
    public void nonNetworkAdminGetsStartFormModel() throws Exception {
        this.randomProcessDefinition = ((RestProcessDefinitionModel)this.restClient.withWorkflowAPI().getAllProcessDefinitions().getOneRandomEntry()).onModel();
        this.restClient.withWorkflowAPI().usingProcessDefinitions(this.randomProcessDefinition).getProcessDefinitionStartFormModel().assertThat().entriesListIsNotEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }
}

