/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.favorites;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestFileModel;
import org.alfresco.rest.model.RestFolderModel;
import org.alfresco.rest.model.RestPersonFavoritesModel;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataLink;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.LinkModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddFavoritesTests
extends RestTest {
    private UserModel adminUserModel;
    private SiteModel siteModel;
    private DataUser.ListUserWithRoles usersWithRoles;
    private RestPersonFavoritesModel restPersonFavoritesModel;
    private FileModel document;
    private FileModel document1;
    private FolderModel folder;
    private FolderModel folder1;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.folder = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createFolder();
        this.document1 = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.folder1 = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createFolder();
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.SANITY}, description="Verify Manager user gets status code 401 if authentication call fails")
    @Test(groups={"rest-api", "favorites", "sanity"})
    public void managerIsNotAbleToAddToFavoritesIfAuthenticationFails() throws Exception {
        UserModel siteManager = this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        siteManager.setPassword("wrongPassword");
        this.restClient.authenticateUser(siteManager).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user add site to favorites with Rest API and status code is 201")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void collaboratorIsAbleToAddToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.and().field("targetGuid").is((Object)this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user add site to favorites with Rest API and status code is 201")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void contributorIsAbleToAddToFavorites() throws JsonToModelConversionException, Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.and().field("targetGuid").is((Object)this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Consumer user add site to favorites with Rest API and status code is 201")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void consumerIsAbleToAddToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.and().field("targetGuid").is((Object)this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user add site to favorites with Rest API and status code is 201")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsAbleToAddToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.siteModel.getGuid());
    }

    @Bug(id="MNT-17157")
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Check that if a favorite already exists with the specified id status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void addFavoriteTwice() throws Exception {
        SiteModel site = ((DataSite)this.dataSite.usingUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager))).createPublicRandomSite();
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addSiteToFavorites(site);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(site);
        this.restClient.assertStatusCodeIs(HttpStatus.CONFLICT);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.SANITY}, description="Add to favorites a file for a Manager, check it was added")
    @Test(groups={"rest-api", "favorites", "sanity"})
    public void managerIsAbleToAddFileToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingAuthUser().addFileToFavorites(this.document);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.document.getNodeRefWithoutVersion());
        RestFileModel restFileModel = this.restPersonFavoritesModel.getTarget().getFile();
        ((RestFileModel)((RestFileModel)((RestFileModel)restFileModel.assertThat().field("mimeType").is((Object)"text/plain")).and().field("isFile").is((Object)"true")).and().field("isFolder").is((Object)"false")).and().field("createdBy").is((Object)this.adminUserModel.getUsername());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.SANITY}, description="Add to favorites a folder for a Manager, check it was added")
    @Test(groups={"rest-api", "favorites", "sanity"})
    public void managerIsAbleToAddFolderToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingAuthUser().addFolderToFavorites(this.folder);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.folder.getNodeRefWithoutVersion());
        RestFolderModel restFolderModel = this.restPersonFavoritesModel.getTarget().getFolder();
        ((RestFolderModel)((RestFolderModel)restFolderModel.assertThat().field("isFile").is((Object)"false")).and().field("isFolder").is((Object)"true")).and().field("createdBy").is((Object)this.adminUserModel.getUsername());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.SANITY}, description="Add to favorites a site for a Manager, check it was added")
    @Test(groups={"rest-api", "favorites", "sanity"})
    public void managerIsAbleToAddSiteToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.siteModel.getGuid());
        RestSiteModel restSiteModel = this.restPersonFavoritesModel.getTarget().getSite();
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)restSiteModel.assertThat().field("visibility").is((Object)this.siteModel.getVisibility())).and().field("guid").is((Object)this.siteModel.getGuid())).and().field("description").is((Object)this.siteModel.getDescription())).and().field("id").is((Object)this.siteModel.getId())).and().field("title").is((Object)this.siteModel.getTitle());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify add favorite specifying -me- string in place of <personid> for request")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToAddFavoriteWhenUsingMeAsUsername() throws Exception {
        UserModel user = this.dataUser.createRandomTestUser();
        this.restPersonFavoritesModel = this.restClient.authenticateUser(user).withCoreAPI().usingMe().addSiteToFavorites(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.siteModel.getGuid());
        this.restClient.authenticateUser(user).withCoreAPI().usingAuthUser().getFavoriteSites().assertThat().entriesListContains("guid", this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Add to favorites a file for a Collaborator, check it was added")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void collaboratorIsAbleToAddFileToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingAuthUser().addFileToFavorites(this.document);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.document.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Add to favorites a file for a Contributor, check it was added")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void contributorIsAbleToAddFileToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingAuthUser().addFileToFavorites(this.document);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.document.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Add to favorites a file for a Consumer, check it was added")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void consumerIsAbleToAddFileToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingAuthUser().addFileToFavorites(this.document);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.document.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Add to favorites a folder for a Collaborator, check it was added")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void collaboratorIsAbleToAddFolderToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).addFolderToFavorites(this.folder);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.folder.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Add to favorites a folder for a Contributor, check it was added")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void contributorIsAbleToAddFolderToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingAuthUser().addFolderToFavorites(this.folder);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.folder.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Add to favorites a folder for a Consumer, check it was added")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void consumerIsAbleToAddFolderToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).addFolderToFavorites(this.folder);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.folder.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Add to favorites a site for a Collaborator, check it was added")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void collaboratorIsAbleToAddSiteToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Add to favorites a site for a Contributor, check it was added")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void contributorIsAbleToAddSiteToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Add to favorites a site for a Consumer, check it was added")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void consumerIsAbleToAddSiteToFavorites() throws Exception {
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Check that if target guid does not describe a site, file, or folder status code is 400")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void addFavoriteUsingInvalidGuid() throws Exception {
        LinkModel link = ((DataLink)((DataLink)this.dataLink.usingAdmin()).usingSite(this.siteModel)).createRandomLink();
        SiteModel site = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        site.setGuid(link.getNodeRef());
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addSiteToFavorites(site);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, site.getGuid().split("/")[3]));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Check that if personId does not exist, status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void addFavoriteUsingInexistentUser() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(new UserModel("random_user", "random_password")).addSiteToFavorites(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "random_user"));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Check that if target guid does not exist, status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void addFavoriteUsingInexistentGuid() throws Exception {
        SiteModel site = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        site.setGuid("random_guid");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addSiteToFavorites(site);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "random_guid"));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Check that if user provides file in target but guid is of a folder status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void addFileToFavoritesUsingFolderGuid() throws Exception {
        String nodeRef = this.document.getNodeRef();
        this.document.setNodeRef(this.folder.getNodeRef());
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addFileToFavorites(this.document);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.adminUserModel.getUsername(), this.folder.getNodeRefWithoutVersion()));
        this.document.setNodeRef(nodeRef);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify add favorite, perform getFavorites call, check value is updated")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void verifyGetFavoritesAfterFavoritingSite() throws Exception {
        UserModel user = this.dataUser.createRandomTestUser();
        this.restPersonFavoritesModel = this.restClient.authenticateUser(user).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(user).withCoreAPI().usingAuthUser().getFavoriteSites().assertThat().entriesListContains("guid", this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify add file favorite with comment id returns status code 201")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void addFileFavoriteUsingCommentId() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestCommentModel comment = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment("This is a comment");
        file.setNodeRef(comment.getId());
        this.restPersonFavoritesModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addFileToFavorites(file);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)file.getNodeRef());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify add file favorite with tag id returns status code 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void addFileFavoriteUsingTagId() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestTagModel returnedModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addTag("random_tag");
        file.setNodeRef(returnedModel.getId());
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addFileToFavorites(file);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.adminUserModel.getUsername(), returnedModel.getId()));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Check that if user provides site in target but id is of a file status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void addSiteToFavoritesUsingFileId() throws Exception {
        String guid = this.siteModel.getGuid();
        this.siteModel.setGuid(this.document.getNodeRefWithoutVersion());
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.document.getNodeRefWithoutVersion()));
        this.siteModel.setGuid(guid);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Check that if user provides folder in target but guid is of a file status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void addFolderToFavoritesUsingFileGuid() throws Exception {
        String nodeRef = this.folder1.getNodeRef();
        this.folder1.setNodeRef(this.document1.getNodeRef());
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addFolderToFavorites(this.folder1);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(this.document1.getNodeRef());
        this.folder1.setNodeRef(nodeRef);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Check that if user provides file in target but guid is of a site status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void addSiteToFavoritesUsingFolderId() throws Exception {
        SiteModel newSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        newSiteModel.setGuid(this.folder.getNodeRef());
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addSiteToFavorites(newSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.folder.getNodeRef()));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Check that if user provides folder in target but guid is of a site status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void addFolderToFavoritesUsingSiteId() throws Exception {
        FolderModel newFolder = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createFolder();
        newFolder.setNodeRef(this.siteModel.getGuid());
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addFolderToFavorites(newFolder);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.adminUserModel.getUsername(), this.siteModel.getGuid()));
    }

    @Bug(id="REPO-1061")
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Check that if user does not have permission to favorite a site status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void verifyFavoriteASiteIfTheUserDoesNotHavePermission() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPrivateRandomSite();
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingAuthUser().addSiteToFavorites(privateSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, privateSite.getGuid())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).containsErrorKey(RestErrorModel.NOT_FOUND_ERRORKEY).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="REPO-4000")
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify the response of favorite a sie with empty body at request")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void verifyFavoriteASiteWithEmptyBody() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"", (String)"people/{personId}/favorites", (String[])new String[]{this.adminUserModel.getUsername()});
        this.restClient.processModel(RestPersonFavoritesModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "No content to map due to end-of-input"));
    }
}

