/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sharedLinks;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.RestSharedLinksModelCollection;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.requests.SharedLinks;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSharedLinksFullTests
extends RestTest {
    private SiteModel privateSite;
    private UserModel adminUser;
    private UserModel userModel;
    protected FileModel file;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPrivateRandomSite();
    }

    @Bug(id="REPO-2365")
    @TestRail(section={"rest-api", "shared-links"}, executionType={ExecutionType.REGRESSION}, description="Verify that a user with permission can get allowableOperations on sharedLinks")
    @Test(groups={"rest-api", "shared-links", "regression"})
    public void getSharedLinksWithAllowableOperations() throws Exception {
        RestSharedLinksModelCollection operationsRequest;
        this.file = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.privateSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        JsonObject userPermission = Json.createObjectBuilder().add("permissions", Json.createObjectBuilder().add("isInheritanceEnabled", true).add("locallySet", Json.createObjectBuilder().add("authorityId", this.userModel.getUsername()).add("name", "SiteConsumer").add("accessStatus", "ALLOWED"))).build();
        String putBody = userPermission.toString();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file).updateNode(putBody);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSharedLinks().createSharedLink(this.file);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestNodeModel permissionsRequest = ((Node)this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.file).usingParams(new String[]{"include=permissions"})).getNode();
        permissionsRequest.assertThat().field("permissions.locallySet.authorityId").is((Object)("[" + this.userModel.getUsername() + "]"));
        int numberOfTries = 0;
        do {
            Thread.sleep(1000L);
            operationsRequest = ((SharedLinks)this.restClient.authenticateUser(this.userModel).withCoreAPI().usingSharedLinks().usingParams(new String[]{"include=allowableOperations"})).getSharedLinks();
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
        } while (operationsRequest.getPagination().getCount() == 0 && ++numberOfTries < 15);
        operationsRequest.getPagination().assertThat().field("count").is((Object)1);
    }
}

