/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.servlet;

import io.restassured.RestAssured;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.codec.binary.Base64;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DownloadContentServletTests
extends RestTest {
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String FILENAME_HEADER = "filename=\"%s\"";
    private static final String ATTACHMENT = "attachment";
    private static final String FILE_CONTENT = "The content of the file.";
    private static String downloadContentServletAttach = "alfresco/d/a/workspace/SpacesStore/";
    private static String downloadContentServletDirect = "alfresco/d/d/workspace/SpacesStore/";
    private UserModel testUser;
    private FileModel testContentFile;
    private String authHeaderEncoded;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        SiteModel testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        FolderModel testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(testSite)).createFolder();
        this.testContentFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingResource((ContentModel)testFolder)).createContent(new FileModel("hotOuside", FileType.TEXT_PLAIN, FILE_CONTENT));
        String authHeader = String.format("%s:%s", this.testUser.getUsername(), this.testUser.getPassword());
        this.authHeaderEncoded = new String(Base64.encodeBase64((byte[])authHeader.getBytes()));
        RestAssured.basePath = "";
        this.restClient.configureRequestSpec().setBasePath(RestAssured.basePath);
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using short descriptor and attach short descriptor.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSShortAttachShort() {
        this.authenticateTestUser();
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentServletAttach + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertEquals((String)FILE_CONTENT, (String)response.getResponse().body().asString());
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, ATTACHMENT);
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, String.format(FILENAME_HEADER, this.testContentFile.getName()));
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using short descriptor and attach long descriptor.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSShortAttachLong() {
        this.authenticateTestUser();
        String downloadContentServletAttachLong = "alfresco/d/attach/workspace/SpacesStore/";
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentServletAttachLong + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertEquals((String)FILE_CONTENT, (String)response.getResponse().body().asString());
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, ATTACHMENT);
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, String.format(FILENAME_HEADER, this.testContentFile.getName()));
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using short descriptor and direct short descriptor.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSShortDirectShort() {
        this.authenticateTestUser();
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentServletDirect + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertEquals((String)FILE_CONTENT, (String)response.getResponse().body().asString());
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, ATTACHMENT);
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, String.format(FILENAME_HEADER, this.testContentFile.getName()));
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using short descriptor and direct long descriptor.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSShortDirectLong() {
        this.authenticateTestUser();
        String downloadContentServletDirectLong = "alfresco/d/direct/workspace/SpacesStore/";
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentServletDirectLong + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertEquals((String)FILE_CONTENT, (String)response.getResponse().body().asString());
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, ATTACHMENT);
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, String.format(FILENAME_HEADER, this.testContentFile.getName()));
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using long descriptor and attach short descriptor.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSLongAttachShort() {
        this.authenticateTestUser();
        String downloadContentLongServletAttach = "alfresco/download/a/workspace/SpacesStore/";
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentLongServletAttach + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertEquals((String)FILE_CONTENT, (String)response.getResponse().body().asString());
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, ATTACHMENT);
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, String.format(FILENAME_HEADER, this.testContentFile.getName()));
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using long descriptor and attach long descriptor.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSLongAttachLong() {
        this.authenticateTestUser();
        String downloadContentLongServletAttachLong = "alfresco/download/attach/workspace/SpacesStore/";
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentLongServletAttachLong + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertEquals((String)FILE_CONTENT, (String)response.getResponse().body().asString());
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, ATTACHMENT);
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, String.format(FILENAME_HEADER, this.testContentFile.getName()));
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using long descriptor and direct short descriptor.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSLongDirectShort() {
        this.authenticateTestUser();
        String downloadContentLongServletDirect = "alfresco/download/d/workspace/SpacesStore/";
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentLongServletDirect + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertEquals((String)FILE_CONTENT, (String)response.getResponse().body().asString());
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, ATTACHMENT);
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, String.format(FILENAME_HEADER, this.testContentFile.getName()));
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using long descriptor and direct long descriptor.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSLongDirectLong() {
        this.authenticateTestUser();
        String downloadContentLongServletDirectLong = "alfresco/download/direct/workspace/SpacesStore/";
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentLongServletDirectLong + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertEquals((String)FILE_CONTENT, (String)response.getResponse().body().asString());
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, ATTACHMENT);
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, String.format(FILENAME_HEADER, this.testContentFile.getName()));
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using short descriptor and attach short uppercase descriptor.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSShortAttachUppercaseShort() {
        this.authenticateTestUser();
        String downloadContentAttachUppercase = "alfresco/d/A/workspace/SpacesStore/";
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentAttachUppercase + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertEquals((String)FILE_CONTENT, (String)response.getResponse().body().asString());
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, ATTACHMENT);
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, String.format(FILENAME_HEADER, this.testContentFile.getName()));
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using short descriptor and direct short uppercase descriptor.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSShortDirectUppercaseShort() {
        this.authenticateTestUser();
        String downloadContentDirectUppercase = "alfresco/d/D/workspace/SpacesStore/";
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentDirectUppercase + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertEquals((String)FILE_CONTENT, (String)response.getResponse().body().asString());
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, ATTACHMENT);
        this.restClient.assertHeaderValueContains(CONTENT_DISPOSITION, String.format(FILENAME_HEADER, this.testContentFile.getName()));
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using attach without specifying {storeType}.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSAttachWithoutStoreType() {
        this.authenticateTestUser();
        String downloadContentLessPathAttach = "alfresco/d/a/SpacesStore/";
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentLessPathAttach + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using direct without specifying {storeType}.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSDirectWithoutStoreType() {
        this.authenticateTestUser();
        String downloadContentLessPathDirect = "alfresco/d/d/SpacesStore/";
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentLessPathDirect + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using direct without specifying {storeType}.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSDirectWithInvalidStoreType() {
        this.authenticateTestUser();
        String downloadContentLessPathDirect = "alfresco/download/d/badWorkspace/SpacesStore/";
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentLessPathDirect + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using direct without specifying {storeType}.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSDirectWithInvalidStoreId() {
        this.authenticateTestUser();
        String downloadContentLessPathDirect = "alfresco/download/d/workspace/badSpacesStore/";
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentLessPathDirect + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using attach without authentication.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSAttachWithoutAuthentication() {
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentServletAttach + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify DownloadContentServlet retrieve content using direct without authentication.")
    @Test(groups={"rest-api", "full", "enterprise"})
    @Bug(id="MNT-21602", status=Bug.Status.FIXED)
    public void verifyDCSDirectWithoutAuthentication() {
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(downloadContentServletDirect + this.testContentFile.getNodeRef() + "/" + this.testContentFile.getName()), (String[])new String[0]);
        this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    private void authenticateTestUser() {
        this.restClient.configureRequestSpec().addHeader("Authorization", String.format("Basic %s", this.authHeaderEncoded)).build();
    }
}

