/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people.deauthorization.community;

import org.alfresco.rest.RestTest;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class DeauthorizeSanityTests
extends RestTest {
    private UserModel userModel;
    private UserModel adminUser;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Check if de-authorization is not implemented in Community Edition")
    public void deauthorizationIsNotImplementedInCommunityEdition() {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(this.userModel).deauthorizeUser();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_IMPLEMENTED);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.userModel).deauthorizeUser();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_IMPLEMENTED);
    }
}

