/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.auth;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestTicketBodyModel;
import org.alfresco.rest.model.RestTicketModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.codec.binary.Base64;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuthTests
extends RestTest {
    private RestWrapper addRestRequestAuthorization(RestTicketModel ticketModel) {
        this.restClient.configureRequestSpec().addHeader("Authorization", "Basic " + this.encodeB64(ticketModel.getId()));
        return this.restClient;
    }

    @TestRail(section={"rest-api", "auth"}, executionType={ExecutionType.SANITY}, description="Verify HttpMethod.POST tickets")
    @Test(groups={"rest-api", "sanity", "auth"})
    public void adminShouldGetTicketBody() throws JsonToModelConversionException, Exception {
        RestTicketBodyModel ticketBody = new RestTicketBodyModel();
        ticketBody.setUserId("admin");
        ticketBody.setPassword("admin");
        RestTicketModel ticketReturned = this.restClient.authenticateUser(this.dataContent.getAdminUser()).withAuthAPI().createTicket(ticketBody);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ticketReturned.assertThat().field("id").contains("TICKET_");
    }

    @TestRail(section={"rest-api", "auth"}, executionType={ExecutionType.SANITY}, description="Verify HttpMethod.GET tickets/-me-")
    @Test(groups={"rest-api", "sanity", "auth"})
    public void randomUserGetTicket() throws Exception {
        UserModel userModel = this.dataUser.createRandomTestUser();
        RestTicketBodyModel ticketBody = new RestTicketBodyModel();
        ticketBody.setUserId(userModel.getUsername());
        ticketBody.setPassword(userModel.getPassword());
        RestTicketModel ticketCreated = this.restClient.authenticateUser(userModel).withAuthAPI().createTicket(ticketBody);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.addRestRequestAuthorization(ticketCreated);
        RestTicketModel ticketReturned = this.restClient.withAuthAPI().getTicket();
        Assert.assertEquals((String)ticketCreated.getId(), (String)ticketReturned.getId());
    }

    @TestRail(section={"rest-api", "auth"}, executionType={ExecutionType.SANITY}, description="Verify HttpMethod.REMOVE tickets/-me-")
    @Test(groups={"rest-api", "sanity", "auth"})
    public void randomUserRemoveTicket() throws Exception {
        UserModel userModel = this.dataUser.createRandomTestUser();
        RestTicketBodyModel ticketBody = new RestTicketBodyModel();
        ticketBody.setUserId(userModel.getUsername());
        ticketBody.setPassword(userModel.getPassword());
        RestTicketModel ticketCreated = this.restClient.authenticateUser(userModel).withAuthAPI().createTicket(ticketBody);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.addRestRequestAuthorization(ticketCreated);
        this.restClient.withAuthAPI().removeTicket();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withAuthAPI().getTicket();
        this.restClient.assertLastError().containsErrorKey("Ticket base authentication required.");
    }

    private String encodeB64(String str) {
        return Base64.encodeBase64String((byte[])str.getBytes());
    }
}

