/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processDefinitions;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessDefinitionImageFullTests
extends RestTest {
    private UserModel adminUser;
    private RestProcessDefinitionModel randomProcessDefinition;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
    }

    @Bug(id="REPO-1911")
    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify if get process definition image returns status code 404 when empty processDefinitionId is used")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getProcessDefinitionImageUsingEmptyProcessDefinitionId() throws Exception {
        this.restClient.authenticateUser(this.adminUser);
        this.randomProcessDefinition = ((RestProcessDefinitionModel)this.restClient.withWorkflowAPI().getAllProcessDefinitions().getOneRandomEntry()).onModel();
        this.randomProcessDefinition.setId("");
        this.restClient.withWorkflowAPI().usingProcessDefinitions(this.randomProcessDefinition).getProcessDefinitionImage();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }
}

