/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.categories;

import jakarta.json.Json;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.categories.CategoriesRestTest;
import org.alfresco.rest.model.RestCategoryLinkBodyModel;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.model.RestCategoryModelsCollection;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ListCategoriesForNodeTests
extends CategoriesRestTest {
    private SiteModel site;
    private FolderModel folder;
    private FileModel file;
    private RestCategoryModel category;

    @Override
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        Step.STEP((String)"Create user and a site");
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        Step.STEP((String)"Create a folder, file in it and a category under root");
        this.folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        this.file = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)this.folder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.category = this.prepareCategoryUnderRoot();
    }

    @Test(groups={"rest-api"})
    public void testListSingleCategoryForNode_usingFile() {
        Step.STEP((String)"Link file to category");
        RestCategoryLinkBodyModel categoryLink = this.createCategoryLinkModelWithId(this.category.getId());
        RestCategoryModel linkedCategory = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategory(categoryLink);
        Step.STEP((String)"Get linked category");
        RestCategoryModelsCollection linkedCategories = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getLinkedCategories();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        linkedCategories.assertThat().entriesListCountIs(1);
        ((RestCategoryModel)linkedCategories.getEntries().get(0)).onModel().assertThat().isEqualTo((Object)linkedCategory, new String[0]);
    }

    @Test(groups={"rest-api"})
    public void testListSingleCategoryForNode_usingFolder() {
        Step.STEP((String)"Link folder to category");
        RestCategoryLinkBodyModel categoryLink = this.createCategoryLinkModelWithId(this.category.getId());
        RestCategoryModel linkedCategory = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.folder).linkToCategory(categoryLink);
        Step.STEP((String)"Get linked category");
        RestCategoryModelsCollection linkedCategories = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.folder).getLinkedCategories();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        linkedCategories.assertThat().entriesListCountIs(1);
        ((RestCategoryModel)linkedCategories.getEntries().get(0)).onModel().assertThat().isEqualTo((Object)linkedCategory, new String[0]);
    }

    @Test(groups={"rest-api"})
    public void testListMultipleCategoriesForNode_usingFile() {
        Step.STEP((String)"Create multiple categories under root");
        List<RestCategoryModel> createdCategories = this.prepareCategoriesUnderRoot(10);
        Step.STEP((String)"Link file to created categories");
        List categoryLinkModels = createdCategories.stream().map(RestCategoryModel::getId).map(this::createCategoryLinkModelWithId).collect(Collectors.toList());
        List createdCategoryLinks = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategories(categoryLinkModels).getEntries();
        Step.STEP((String)"Get categories which are linked from file and compare them to created category links");
        RestCategoryModelsCollection linkedCategories = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getLinkedCategories();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        linkedCategories.assertThat().entriesListCountIs(createdCategoryLinks.size());
        IntStream.range(0, createdCategoryLinks.size()).forEach(i -> ((RestCategoryModel)linkedCategories.getEntries().get(i)).onModel().assertThat().isEqualTo((Object)((RestCategoryModel)createdCategoryLinks.get(i)).onModel(), new String[0]));
    }

    @Test(groups={"rest-api"})
    public void testListCategoriesForNode_withoutLinkedCategories() {
        Step.STEP((String)"Try to get linked categories and expect empty list");
        RestCategoryModelsCollection linkedCategories = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getLinkedCategories();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        linkedCategories.assertThat().entriesListIsEmpty();
    }

    @Test(groups={"rest-api"})
    public void testListCategoriesForNode_usingNonExistingNodeAndExpect404() {
        Step.STEP((String)"Try to get linked categories for non-existing node and expect 404");
        RepoTestModel nonExistingNode = this.createNodeModelWithId("non-existing-id");
        RestCategoryModelsCollection linkedCategories = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode(nonExistingNode).getLinkedCategories();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        linkedCategories.assertThat().entriesListIsEmpty();
    }

    @Test(groups={"rest-api"})
    public void testListCategoriesForNode_asUserWithoutReadPermissionAndExpect403() {
        Step.STEP((String)"Link content to category");
        RestCategoryLinkBodyModel categoryLink = this.createCategoryLinkModelWithId(this.category.getId());
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategory(categoryLink);
        Step.STEP((String)"Create another user and deny consumer rights");
        UserModel userWithoutRights = this.dataUser.createRandomTestUser();
        this.denyPermissionsForUser(userWithoutRights.getUsername(), "Consumer", this.file);
        Step.STEP((String)"Try to get linked categories using user without read permission and expect 403");
        this.restClient.authenticateUser(userWithoutRights).withCoreAPI().usingNode((RepoTestModel)this.file).getLinkedCategories();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api"})
    public void testListCategoriesForNode_usingTagInsteadOfContentAndExpect422() {
        Step.STEP((String)"Add tag to file");
        RestTagModel tag = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).addTag("someTag");
        RepoTestModel tagNode = this.createNodeModelWithId(tag.getId());
        Step.STEP((String)"Try to get linked categories for a tag and expect 422");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode(tagNode).getLinkedCategories();
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    private void denyPermissionsForUser(String username, String role, FileModel file) {
        String putPermissionsBody = Json.createObjectBuilder().add("permissions", Json.createObjectBuilder().add("isInheritanceEnabled", true).add("locallySet", Json.createObjectBuilder().add("authorityId", username).add("name", role).add("accessStatus", "DENIED"))).build().toString();
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)file).updateNode(putPermissionsBody);
    }
}

