/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.favorites;

import java.util.UUID;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.dataprep.SiteService;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.rest.model.RestSiteModelsCollection;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetFavoriteSiteTests
extends RestTest {
    private UserModel userModel;
    private SiteModel siteModel1;
    private SiteModel siteModel2;
    private RestSiteModel restSiteModel;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel1 = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.siteModel2 = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel1, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        ((DataSite)((DataSite)this.dataSite.usingUser(this.userModel)).usingSite(this.siteModel1)).addSiteToFavorites();
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify manager user gets its specific favorite site with Rest API and response is successful (200)")
    public void managerUserGetsFavoriteSiteWithSuccess() throws Exception {
        UserModel managerUser = this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel2)).addSiteToFavorites();
        this.restSiteModel = this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().getFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteModel)this.restSiteModel.assertThat().field("id").is((Object)this.siteModel1.getId())).and().field("title").isNotNull();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator user gets its specific favorite site with Rest API and response is successful (200)")
    public void collaboratorUserGetsFavoriteSiteWithSuccess() throws Exception {
        UserModel collaboratorUser = this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator);
        ((DataSite)((DataSite)this.dataSite.usingUser(collaboratorUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(collaboratorUser)).usingSite(this.siteModel2)).addSiteToFavorites();
        this.restSiteModel = this.restClient.authenticateUser(collaboratorUser).withCoreAPI().usingAuthUser().getFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteModel)this.restSiteModel.assertThat().field("id").is((Object)this.siteModel1.getId())).and().field("title").isNotNull();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor user gets its specific favorite site with Rest API and response is successful (200)")
    public void contributorUserGetsFavoriteSiteWithSuccess() throws Exception {
        UserModel contributorUser = this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor);
        ((DataSite)((DataSite)this.dataSite.usingUser(contributorUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(contributorUser)).usingSite(this.siteModel2)).addSiteToFavorites();
        this.restSiteModel = this.restClient.authenticateUser(contributorUser).withCoreAPI().usingAuthUser().getFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteModel)this.restSiteModel.assertThat().field("id").is((Object)this.siteModel1.getId())).and().field("title").isNotNull();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer user gets its specific favorite site with Rest API and response is successful (200)")
    public void consumerUserGetsFavoriteSiteWithSuccess() throws Exception {
        UserModel consumerUser = this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer);
        ((DataSite)((DataSite)this.dataSite.usingUser(consumerUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(consumerUser)).usingSite(this.siteModel2)).addSiteToFavorites();
        this.restSiteModel = this.restClient.authenticateUser(consumerUser).withCoreAPI().usingAuthUser().getFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteModel)this.restSiteModel.assertThat().field("id").is((Object)this.siteModel1.getId())).and().field("title").isNotNull();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user gets specific favorite site of any user with Rest API and response is successful (200)")
    public void adminUserGetsAnyFavoriteSiteWithSuccess() throws Exception {
        UserModel adminUser = this.dataUser.getAdminUser();
        UserModel anyUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataSite)((DataSite)this.dataSite.usingUser(anyUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(anyUser)).usingSite(this.siteModel2)).addSiteToFavorites();
        this.restSiteModel = this.restClient.authenticateUser(adminUser).withCoreAPI().usingUser(anyUser).getFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteModel)this.restSiteModel.assertThat().field("id").is((Object)this.siteModel1.getId())).and().field("title").isNotNull();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify manager user fails to get specific favorite site of another user with Rest API and response is successful (403)")
    public void managerUserFailsToGetFavoriteSiteOfAnotherUser() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.siteModel1, UserRole.SiteManager);
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel2)).addSiteToFavorites();
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingUser(this.userModel).getFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify manager user is NOT Authorized gets its specific favorite site with Rest API when authentication fails (401)")
    public void managerUserNotAuthorizedFailsToGetFavoriteSite() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.siteModel1, UserRole.SiteManager);
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel2)).addSiteToFavorites();
        managerUser.setPassword("newpassword");
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().getFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify invalid request returns status 404 when personId does not exist")
    public void getFavoriteSiteWithNonExistentPersonId() throws Exception {
        UserModel someUser = new UserModel("someUser", DataUser.PASSWORD);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(someUser).getFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "someUser"));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify invalid request returns status 404 when siteId does not exist")
    public void getFavoriteSiteWithNonExistentSiteId() throws Exception {
        SiteModel nonExistentSite = new SiteModel("nonExistentSite");
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingAuthUser().getFavoriteSite(nonExistentSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.userModel.getUsername(), nonExistentSite.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify User fails to get specific favorite site of admin with Rest API and response is 403")
    public void userFailsToGetFavoriteSiteOfAdmin() throws Exception {
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.dataUser.getAdminUser()).getFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify request with empty site id")
    public void getFavoriteSiteWithEmptySiteId() throws Exception {
        this.restClient.authenticateUser(this.userModel).withCoreAPI();
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"people/{personId}/favorite-sites/{siteId}?{parameters}", (String[])new String[]{this.userModel.getUsername(), "", this.restClient.getParameters()});
        RestSiteModelsCollection sites = (RestSiteModelsCollection)this.restClient.processModels(RestSiteModelsCollection.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        sites.assertThat().entriesListIsNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify invalid request returns status 401 when user does not exist")
    public void getFavoriteSiteWithFictionalPersonId() {
        UserModel fictionalUser = new UserModel("FictionalUser" + String.valueOf(UUID.randomUUID()), "password");
        this.restClient.authenticateUser(fictionalUser).withCoreAPI().usingAuthUser().getFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify invalid request returns status 404 when another user get favorite site of an user")
    public void getFavoriteSiteWithAnotherUser() throws Exception {
        UserModel user = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(user).withCoreAPI().usingAuthUser().getFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, user.getUsername(), this.siteModel1.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify request returns status 200 when using -me-")
    public void getFavoriteSiteUsingMe() throws Exception {
        this.restSiteModel = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().getFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)this.restSiteModel.assertThat().field("id").is((Object)this.siteModel1.getId())).and().field("title").is((Object)this.siteModel1.getTitle())).and().field("role").is((Object)UserRole.SiteManager.toString())).and().field("visibility").is((Object)SiteService.Visibility.PUBLIC.toString())).and().field("guid").isNotEmpty()).and().field("description").is((Object)this.siteModel1.getDescription())).and().field("preset").is((Object)"site-dashboard");
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify invalid request returns status 404 when providing folder name instead of site id")
    public void getFavoriteSiteUsingFolder() throws Exception {
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel1)).createFolder();
        SiteModel siteFolder = new SiteModel(folder.getName());
        this.restSiteModel = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().getFavoriteSite(siteFolder);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.userModel.getUsername(), folder.getName()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify invalid request returns status 404 when providing file name instead of site id")
    public void getFavoriteSiteUsingFile() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel1)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        SiteModel siteFolder = new SiteModel(file.getName());
        this.restSiteModel = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().getFavoriteSite(siteFolder);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.userModel.getUsername(), file.getName()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify request returns status 200 when using valid parameters")
    public void getFavoriteSiteUsingParameters() throws Exception {
        this.restSiteModel = this.restClient.withParams(new String[]{"maxItems=100"}).authenticateUser(this.userModel).withCoreAPI().usingMe().getFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteModel)this.restSiteModel.assertThat().field("id").is((Object)this.siteModel1.getId())).and().field("title").is((Object)this.siteModel1.getTitle());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify request returns status 400 when using maxItems=0")
    public void getFavoriteSiteUsingInvalidMaxItems() throws Exception {
        this.restSiteModel = this.restClient.withParams(new String[]{"maxItems=0"}).authenticateUser(this.userModel).withCoreAPI().usingMe().getFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify request returns status 401 when using invalid network")
    public void getFavoriteSiteUsingInvalidNetwork() throws Exception {
        UserModel invalidUserNetwork = this.dataUser.createRandomTestUser();
        SiteModel site = ((DataSite)this.dataSite.usingUser(invalidUserNetwork)).createPublicRandomSite();
        ((DataSite)((DataSite)this.dataSite.usingUser(invalidUserNetwork)).usingSite(site)).addSiteToFavorites();
        invalidUserNetwork.setDomain("invalidNetwork");
        this.restSiteModel = this.restClient.authenticateUser(invalidUserNetwork).withCoreAPI().usingMe().getFavoriteSite(site);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }
}

