/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.tags;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.model.RestTagModelsCollection;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.testng.annotations.BeforeClass;

public class TagsDataPrep
extends RestTest {
    protected static UserModel adminUserModel;
    protected static UserModel userModel;
    protected static DataUser.ListUserWithRoles usersWithRoles;
    protected static SiteModel siteModel;
    protected static FileModel document;
    protected static FolderModel folder;
    protected static FolderModel folder2;
    protected static RestTagModelsCollection folder2tags;
    protected static String documentTagValue;
    protected static String documentTagValue2;
    protected static String folderTagValue;
    protected static RestTagModel documentTag;
    protected static RestTagModel documentTag2;
    protected static RestTagModel folderTag;
    protected static RestTagModel orphanTag;
    protected static RestTagModel returnedModel;
    protected static RestTagModelsCollection returnedCollection;

    @BeforeClass
    public void init() throws Exception {
        adminUserModel = this.dataUser.getAdminUser();
        userModel = this.dataUser.createRandomTestUser();
        siteModel = ((DataSite)this.dataSite.usingUser(adminUserModel)).createPublicRandomSite();
        usersWithRoles = ((DataUser)this.dataUser.usingAdmin()).addUsersWithRolesToSite(siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        document = ((DataContent)this.dataContent.usingUser(adminUserModel).usingSite(siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        folder = ((DataContent)this.dataContent.usingUser(adminUserModel).usingSite(siteModel)).createFolder();
        folder2 = ((DataContent)this.dataContent.usingUser(adminUserModel).usingSite(siteModel)).createFolder();
        documentTagValue = RandomData.getRandomName((String)"tag").toLowerCase();
        documentTagValue2 = RandomData.getRandomName((String)"tag").toLowerCase();
        folderTagValue = RandomData.getRandomName((String)"tag").toLowerCase();
        this.restClient.authenticateUser(adminUserModel);
        documentTag = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(documentTagValue);
        documentTag2 = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(documentTagValue2);
        folderTag = this.restClient.withCoreAPI().usingResource((RepoTestModel)folder).addTag(folderTagValue);
        orphanTag = this.restClient.withCoreAPI().createSingleTag(RestTagModel.builder().tag(RandomData.getRandomName((String)"orphan-tag").toLowerCase()).create());
        folder2tags = this.restClient.withCoreAPI().usingResource((RepoTestModel)folder2).addTags(new String[]{folderTagValue, documentTagValue});
        Utility.sleep((int)500, (int)60000, () -> {
            returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000", "where=(tag MATCHES ('*tag*'))"}).withCoreAPI().getTags();
            ((RestModels)((RestModels)((RestModels)returnedCollection.assertThat().entriesListContains("tag", documentTagValue)).and().entriesListContains("tag", documentTagValue2)).and().entriesListContains("tag", folderTagValue)).and().entriesListContains("tag", orphanTag.getTag());
        });
    }

    protected RestTagModel createTagForDocument(FileModel document) {
        String documentTagValue = RandomData.getRandomName((String)"tag");
        return this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(documentTagValue);
    }

    protected RestTagModel createTagModelWithId(String id) {
        return this.createTagModelWithIdAndName(id, RandomData.getRandomName((String)"tag"));
    }

    protected RestTagModel createTagModelWithIdAndName(String id, String tag) {
        return RestTagModel.builder().id(id).tag(tag).create();
    }

    protected RestTagModel createTagModelWithName(String tagName) {
        return RestTagModel.builder().tag(tagName).create();
    }
}

