/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestPersonModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetPeopleSanityTests
extends RestTest {
    UserModel userModel;
    SiteModel siteModel;
    UserModel searchedUser;
    UserModel adminUser;
    private RestPersonModel personModel;
    private String domain = "@tas-automation.org";

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.searchedUser = this.dataUser.createRandomTestUser();
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify manager user gets a person with Rest API and response is successful")
    public void managerUserChecksIfPersonIsPresent() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.siteModel, UserRole.SiteManager);
        this.personModel = this.restClient.authenticateUser(managerUser).withCoreAPI().usingUser(this.searchedUser).getPerson();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPersonModel)((RestPersonModel)((RestPersonModel)this.personModel.assertThat().field("id").is((Object)this.searchedUser.getUsername())).and().field("firstName").is((Object)("FN-" + this.searchedUser.getUsername()))).and().field("email").is((Object)(this.searchedUser.getUsername() + this.domain))).and().field("emailNotificationsEnabled").is((Object)"true");
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify collaborator user gets a person with Rest API and response is successful")
    public void collaboratorUserChecksIfPersonIsPresent() throws Exception {
        UserModel collaboratorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(collaboratorUser, this.siteModel, UserRole.SiteCollaborator);
        this.personModel = this.restClient.authenticateUser(collaboratorUser).withCoreAPI().usingUser(this.searchedUser).getPerson();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPersonModel)((RestPersonModel)((RestPersonModel)this.personModel.assertThat().field("id").is((Object)this.searchedUser.getUsername())).and().field("firstName").is((Object)("FN-" + this.searchedUser.getUsername()))).and().field("email").is((Object)(this.searchedUser.getUsername() + this.domain))).and().field("emailNotificationsEnabled").is((Object)"true");
    }

    @Test(groups={"rest-api", "people", "comments", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify contributor user gets a person with Rest API and response is successful")
    public void contributorUserChecksIfPersonIsPresent() throws Exception {
        UserModel contributorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(contributorUser, this.siteModel, UserRole.SiteContributor);
        this.personModel = this.restClient.authenticateUser(contributorUser).withCoreAPI().usingUser(this.searchedUser).getPerson();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPersonModel)((RestPersonModel)((RestPersonModel)this.personModel.assertThat().field("id").is((Object)this.searchedUser.getUsername())).and().field("firstName").is((Object)("FN-" + this.searchedUser.getUsername()))).and().field("email").is((Object)(this.searchedUser.getUsername() + this.domain))).and().field("emailNotificationsEnabled").is((Object)"true");
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify consumer user gets a person with Rest API and response is successful")
    public void consumerUserChecksIfPersonIsPresent() throws Exception {
        UserModel consumerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(consumerUser, this.siteModel, UserRole.SiteConsumer);
        this.personModel = this.restClient.authenticateUser(consumerUser).withCoreAPI().usingUser(this.searchedUser).getPerson();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPersonModel)((RestPersonModel)((RestPersonModel)this.personModel.assertThat().field("id").is((Object)this.searchedUser.getUsername())).and().field("firstName").is((Object)("FN-" + this.searchedUser.getUsername()))).and().field("email").is((Object)(this.searchedUser.getUsername() + this.domain))).and().field("emailNotificationsEnabled").is((Object)"true");
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify admin user gets a person with Rest API and response is successful")
    public void adminUserChecksIfPersonIsPresent() throws Exception {
        this.personModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(this.searchedUser).getPerson();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPersonModel)((RestPersonModel)((RestPersonModel)this.personModel.assertThat().field("id").is((Object)this.searchedUser.getUsername())).and().field("firstName").is((Object)("FN-" + this.searchedUser.getUsername()))).and().field("email").is((Object)(this.searchedUser.getUsername() + this.domain))).and().field("emailNotificationsEnabled").is((Object)"true");
    }

    @Test(groups={"rest-api", "people"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify manager user gets a non existing person with Rest API and person is not found")
    public void managerUserChecksIfNonExistingPersonIsPresent() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.siteModel, UserRole.SiteManager);
        UserModel searchedNonUser = new UserModel("nonexistinguser", DataUser.PASSWORD);
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingUser(searchedNonUser).getPerson();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }
}

