/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TagModel;
import org.alfresco.utility.report.log.Step;
import org.testng.Assert;

public class RestTagModel
extends TagModel
implements IRestModel<RestTagModel> {
    @JsonProperty(value="entry")
    RestTagModel model;
    protected Integer count;

    @Override
    public RestTagModel onModel() {
        return this.model;
    }

    public RestTagModel assertResponseIsNotEmpty() {
        Step.STEP((String)String.format("REST API: Assert get tags response is not empty", new Object[0]));
        Assert.assertFalse((boolean)this.getId().isEmpty(), (String)"Get tags response is empty.");
        return this;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestTagModel tagModel = (RestTagModel)o;
        return Objects.equals(this.id, tagModel.id) && Objects.equals(this.tag, tagModel.tag) && Objects.equals(this.count, tagModel.count);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tag, this.count);
    }

    public String toString() {
        return "RestTagModel{id='" + this.id + ", tag='" + this.tag + "', count=" + this.count + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private String tag;
        private Integer count;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public RestTagModel create() {
            RestTagModel tag = new RestTagModel();
            tag.setId(this.id);
            tag.setTag(this.tag);
            tag.setCount(this.count);
            return tag;
        }
    }
}

