/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.rest.model.RestTaskModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetTasksTests
extends RestTest {
    UserModel userModel;
    UserModel userNotInvolved;
    UserModel assigneeUser;
    UserModel adminUser;
    UserModel adminTenantUser;
    UserModel tenantUser;
    UserModel tenantUserAssignee;
    SiteModel siteModel;
    FileModel fileModel;
    RestTaskModelsCollection taskModels;
    RestTaskModelsCollection taskCollections;
    RestTaskModelsCollection tenantTask;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.userNotInvolved = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.assigneeUser = this.dataUser.createRandomTestUser();
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify admin user gets all existing tasks with Rest API and response is successfull (200)")
    public void adminUserGetsAllTasks() throws Exception {
        UserModel adminUser = this.dataUser.getAdminUser();
        this.taskModels = this.restClient.authenticateUser(adminUser).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.taskModels.assertThat().entriesListIsNotEmpty();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify asignee user gets its existing tasks with Rest API and response is successfull (200)")
    public void assigneeUserGetsItsTasks() throws Exception {
        this.taskModels = this.restClient.authenticateUser(this.assigneeUser).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.taskModels.assertThat().entriesListIsNotEmpty()).and().entriesListCountIs(1)).and().entriesListContains("assignee", this.assigneeUser.getUsername());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify candidate user that claims the task gets its existing tasks with Rest API and response is successfull (200)")
    @Bug(id="MNT-16967")
    public void candidateUserGetsItsTasks() throws Exception {
        UserModel userModel1 = this.dataUser.createRandomTestUser();
        UserModel userModel2 = this.dataUser.createRandomTestUser();
        GroupModel group = this.dataGroup.createRandomGroup();
        this.dataGroup.addListOfUsersToGroup(group, new UserModel[]{userModel1, userModel2});
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(group);
        this.taskModels = this.restClient.authenticateUser(userModel1).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.taskModels.assertThat().entriesListIsNotEmpty();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify candidate user that claims the task gets its existing tasks with Rest API and response is successfull (200)")
    public void candidateUserThatClaimsTaskGetsItsTasks() throws Exception {
        UserModel userModel1 = this.dataUser.createRandomTestUser();
        UserModel userModel2 = this.dataUser.createRandomTestUser();
        GroupModel group = this.dataGroup.createRandomGroup();
        this.dataGroup.addListOfUsersToGroup(group, new UserModel[]{userModel1, userModel2});
        TaskModel taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(group);
        ((DataWorkflow)this.dataWorkflow.usingUser(userModel1)).claimTask(taskModel);
        this.taskModels = this.restClient.authenticateUser(userModel1).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.taskModels.assertThat().entriesListIsNotEmpty();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify candidate user without claim gets no tasks with Rest API and response is successfull (200)")
    public void candidateUserWithoutClaimTaskGetsNoTasks() throws Exception {
        UserModel userModel1 = this.dataUser.createRandomTestUser();
        UserModel userModel2 = this.dataUser.createRandomTestUser();
        GroupModel group = this.dataGroup.createRandomGroup();
        this.dataGroup.addListOfUsersToGroup(group, new UserModel[]{userModel1, userModel2});
        TaskModel taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(group);
        ((DataWorkflow)this.dataWorkflow.usingUser(userModel1)).claimTask(taskModel);
        this.taskModels = this.restClient.authenticateUser(userModel2).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.taskModels.assertThat().entriesListIsEmpty();
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Check that skipCount parameter is applied.")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void skipCountParameterApplied() throws Exception {
        this.taskCollections = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withParams(new String[]{"orderBy=description ASC"}).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestTaskModel firstTask = ((RestTaskModel)this.taskCollections.getEntries().get(0)).onModel();
        RestTaskModel secondTask = ((RestTaskModel)this.taskCollections.getEntries().get(1)).onModel();
        this.taskModels = this.restClient.withParams(new String[]{"orderBy=description ASC&skipCount=2"}).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.taskModels.assertThat().entriesListDoesNotContain("id", firstTask.getId())).assertThat().entriesListDoesNotContain("id", secondTask.getId());
        this.taskModels.assertThat().paginationField("skipCount").is("2");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Check that maxItems parameter is applied.")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void maxItemsParameterApplied() throws Exception {
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().addProcess("activitiAdhoc", this.assigneeUser, false, CMISUtil.Priority.Low);
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().addProcess("activitiAdhoc", this.adminUser, false, CMISUtil.Priority.Low);
        this.taskCollections = this.restClient.authenticateUser(this.userModel).withParams(new String[]{"orderBy=assignee ASC"}).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.taskModels = this.restClient.withParams(new String[]{"orderBy=startedAt DESC&maxItems=2"}).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.taskModels.assertThat().entriesListIsNotEmpty()).assertThat().entriesListContains("assignee", this.assigneeUser.getUsername())).assertThat().entriesListDoesNotContain("assignee", this.userModel.getUsername());
        this.taskModels.assertThat().paginationField("maxItems").is("2");
        this.taskModels.assertThat().paginationField("count").is("2");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Check that properties parameter is applied.")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void propertiesParameterApplied() throws Exception {
        this.taskModels = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withParams(new String[]{"properties=name,description"}).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)this.taskModels.assertThat().entriesListIsNotEmpty()).assertThat().entriesListContains("name")).assertThat().entriesListContains("description")).assertThat().entriesListDoesNotContain("processDefinitionId")).assertThat().entriesListDoesNotContain("processId")).assertThat().entriesListDoesNotContain("startedAt")).assertThat().entriesListDoesNotContain("id")).assertThat().entriesListDoesNotContain("state")).assertThat().entriesListDoesNotContain("activityDefinitionId")).assertThat().entriesListDoesNotContain("priority")).assertThat().entriesListDoesNotContain("formResourceKey");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Use invalid where parameter. Check default error model schema.")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void invalidWhereParameterCheckDefaultErrorModelSchema() throws Exception {
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).where("assignee AND '" + this.assigneeUser.getUsername() + "'").withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.INVALID_QUERY_ERRORKEY).containsSummary(String.format(RestErrorModel.INVALID_WHERE_QUERY, "(assignee AND '" + this.assigneeUser.getUsername() + "')")).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify the request in case of any user which is not involved.")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void requestWithUserNotInvolved() throws Exception {
        this.taskModels = this.restClient.authenticateUser(this.userNotInvolved).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.taskModels.assertThat().entriesListIsEmpty();
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Check that orderBy parameter is applied.")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void orderByParameterApplied() throws Exception {
        this.taskModels = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withParams(new String[]{"orderBy=id"}).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.taskModels.assertThat().entriesListIsNotEmpty()).and().entriesListIsSortedAscBy("id");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Check that orderBy parameter is applied and supports only one parameter.")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void orderByParameterSupportsOnlyOneParameter() throws Exception {
        this.taskModels = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withParams(new String[]{"orderBy=id,processDefinitionId"}).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Only one order by parameter is supported");
        this.taskModels.assertThat().entriesListIsEmpty();
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Check that where parameter is applied.")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void whereParameterApplied() throws Exception {
        UserModel anotherAssignee = this.dataUser.createRandomTestUser();
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(anotherAssignee);
        this.taskModels = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withParams(new String[]{"where=(assignee='" + anotherAssignee.getUsername() + "')"}).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.taskModels.assertThat().entriesListIsNotEmpty()).and().entriesListContains("assignee", anotherAssignee.getUsername())).and().entriesListCountIs(1);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Check that invalid orderBy parameter applied returns 400 status code.")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void invalidOrderByParameterApplied() throws Exception {
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withParams(new String[]{"orderBy=invalidParameter"}).withWorkflowAPI().getTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("invalidParameter is not supported");
    }
}

