/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rules;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.model.RestActionBodyExecTemplateModel;
import org.alfresco.rest.model.RestCompositeConditionDefinitionModel;
import org.alfresco.rest.model.RestRuleModel;
import org.alfresco.rest.requests.FolderRules;
import org.alfresco.rest.rules.RulesRestTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"rules"})
public class UpdateRulesTests
extends RulesRestTest {
    private UserModel user;
    private SiteModel site;
    private FolderModel ruleFolder;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        this.ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void updateRule() {
        RestRuleModel rule = this.createAndSaveRule("Rule name");
        Step.STEP((String)"Try to update the rule.");
        RestRuleModel updatedRuleModel = this.rulesUtils.createRuleModel("Updated rule name");
        RestRuleModel updatedRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), updatedRuleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleModel)((RestRuleModel)updatedRule.assertThat().field("id").is((Object)rule.getId())).assertThat().field("name").is((Object)"Updated rule name")).assertThat().field("isShared").isNull();
    }

    @Test(groups={"rest-api", "rules"})
    public void updateRuleForNonExistentFolder() {
        RestRuleModel rule = this.createAndSaveRule("Rule name");
        Step.STEP((String)"Try to update a rule in a non-existent folder.");
        FolderModel nonExistentFolder = FolderModel.getRandomFolderModel();
        nonExistentFolder.setNodeRef("fake-id");
        RestRuleModel updatedRuleModel = new RestRuleModel();
        updatedRuleModel.setName("Updated rule name");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)nonExistentFolder).usingDefaultRuleSet().updateRule(rule.getId(), updatedRuleModel);
        this.restClient.assertLastError().statusCodeIs(HttpStatus.NOT_FOUND).containsSummary("Folder with id fake-id was not found");
    }

    @Test(groups={"rest-api", "rules"})
    public void updateRuleForNonExistentRuleSet() {
        RestRuleModel rule = this.createAndSaveRule("Rule name");
        Step.STEP((String)"Try to update a rule in a non-existent rule set.");
        RestRuleModel updatedRuleModel = new RestRuleModel();
        updatedRuleModel.setName("Updated rule name");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingRuleSet("fake-id").updateRule(rule.getId(), updatedRuleModel);
        this.restClient.assertLastError().statusCodeIs(HttpStatus.NOT_FOUND).containsSummary("Rule set with id fake-id was not found");
    }

    @Test(groups={"rest-api", "rules"})
    public void updateRuleForNonExistentRuleId() {
        Step.STEP((String)"Try to update a rule that doesn't exist.");
        RestRuleModel updatedRuleModel = new RestRuleModel();
        updatedRuleModel.setName("Updated rule name");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule("fake-id", updatedRuleModel);
        this.restClient.assertLastError().statusCodeIs(HttpStatus.NOT_FOUND).containsSummary("fake-id was not found");
    }

    @Test(groups={"rest-api", "rules"})
    public void requirePermissionToUpdateRule() {
        Step.STEP((String)"Create a user and use them to create a private site containing a folder");
        UserModel privateUser = this.dataUser.createRandomTestUser();
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(privateUser)).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingUser(privateUser).usingSite(privateSite)).createFolder();
        Step.STEP((String)"Create a collaborator and check they don't have permission to create a rule");
        UserModel collaborator = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(collaborator, privateSite, UserRole.SiteCollaborator);
        RestRuleModel ruleModel = new RestRuleModel();
        ruleModel.setName("ruleName");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.assertLastError().containsSummary("Insufficient permissions to manage rules");
    }

    @Test(groups={"rest-api", "rules"})
    public void updateRuleToHaveEmptyName() {
        RestRuleModel rule = this.createAndSaveRule("Rule name");
        Step.STEP((String)"Try to update the rule to have no name.");
        RestRuleModel updatedRuleModel = this.rulesUtils.createRuleModel("");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), updatedRuleModel);
        this.restClient.assertLastError().statusCodeIs(HttpStatus.BAD_REQUEST).containsSummary("Rule name is a mandatory parameter");
    }

    @Test(groups={"rest-api", "rules"})
    public void tryToUpdateRuleId() {
        RestRuleModel rule = this.createAndSaveRule("Rule name");
        Step.STEP((String)"Try to update the rule id and check it isn't changed.");
        RestRuleModel updatedRuleModel = this.rulesUtils.createRuleModel("Rule name");
        updatedRuleModel.setId("new-rule-id");
        RestRuleModel updatedRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), updatedRuleModel);
        updatedRule.assertThat().field("id").is((Object)rule.getId());
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void updateRuleWithIncludedFields() {
        RestRuleModel rule = this.createAndSaveRule("Rule name");
        Step.STEP((String)"Try to update the rule.");
        RestRuleModel updatedRuleModel = this.rulesUtils.createRuleModel("Updated rule name");
        RestRuleModel updatedRule = ((FolderRules)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().include(new String[]{"isShared"})).updateRule(rule.getId(), updatedRuleModel);
        updatedRule.assertThat().field("isShared").isNotNull();
    }

    @Test(groups={"rest-api", "rules"})
    public void updateRuleWithoutActionsShouldFail() {
        RestRuleModel rule = this.createAndSaveRule("Rule name");
        Step.STEP((String)"Try to update the rule - set no actions.");
        rule.setActions(null);
        ((FolderRules)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().include(new String[]{"isShared"})).updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("A rule must have at least one action");
    }

    @Test(groups={"rest-api", "rules"})
    public void updateRuleWithInvalidActionDefinitionShouldFail() {
        RestRuleModel rule = this.createAndSaveRule("Rule name");
        Step.STEP((String)"Try to update the rule - set no actions.");
        RestActionBodyExecTemplateModel invalidAction = new RestActionBodyExecTemplateModel();
        String actionDefinitionId = "invalid-definition-value";
        invalidAction.setActionDefinitionId("invalid-definition-value");
        invalidAction.setParams(Map.of("dummy-key", "dummy-value"));
        rule.setActions(List.of(invalidAction));
        ((FolderRules)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().include(new String[]{"isShared"})).updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary(String.format("Invalid rule action definition requested %s", "invalid-definition-value"));
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void updateCopyRuleWithResponseFromPOST() {
        FolderModel destination = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        RestActionBodyExecTemplateModel copyAction = new RestActionBodyExecTemplateModel();
        copyAction.setActionDefinitionId("copy");
        copyAction.setParams((Map)ImmutableMap.of((Object)"destination-folder", (Object)destination.getNodeRef()));
        RestRuleModel rule = this.createAndSaveRule("Rule name", List.of(copyAction));
        Step.STEP((String)"Try to update the rule.");
        rule.setName("Updated rule name");
        RestRuleModel updatedRule = ((FolderRules)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().include(new String[]{"isShared"})).updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleModel)((RestRuleModel)updatedRule.assertThat().field("name").is((Object)"Updated rule name")).assertThat().field("actions.actionDefinitionId").is(List.of("copy"))).assertThat().field("actions.params").is(List.of(ImmutableMap.of((Object)"destination-folder", (Object)destination.getNodeRef())));
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void updateRuleFields() {
        RestRuleModel rule = this.createAndSaveRule(this.rulesUtils.createRuleModelWithModifiedValues());
        Step.STEP((String)"Try to update the rule fields.");
        rule.setName("Updated rule name");
        rule.setTriggers(List.of("inbound"));
        String updatedDescription = "Updated description";
        rule.setDescription("Updated description");
        rule.setIsEnabled(false);
        rule.setIsInheritable(false);
        rule.setIsAsynchronous(false);
        rule.setErrorScript(null);
        RestRuleModel updatedRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleModel)updatedRule.assertThat().isEqualTo((Object)rule, new String[]{"id"})).assertThat().field("id").isNotNull();
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void updateRuleAddConditions() {
        RestRuleModel rule = this.createAndSaveRule(this.rulesUtils.createRuleModelWithModifiedValues());
        Step.STEP((String)"Try to update the rule and add conditions.");
        rule.setConditions(this.rulesUtils.createVariousConditions());
        RestRuleModel updatedRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleModel)updatedRule.assertThat().isEqualTo((Object)rule, new String[]{"id"})).assertThat().field("id").isNotNull();
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void updateRuleAddNullConditions() {
        RestRuleModel rule = this.createAndSaveRule(this.rulesUtils.createRuleModelWithModifiedValues());
        Step.STEP((String)"Try to update the rule and add null conditions.");
        rule.setConditions(null);
        RestRuleModel updatedRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleModel)updatedRule.assertThat().isEqualTo((Object)rule, new String[]{"id"})).assertThat().field("id").isNotNull();
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void updateRuleModifyConditions() {
        RestRuleModel ruleModelWithInitialValues = this.rulesUtils.createRuleModelWithModifiedValues();
        ruleModelWithInitialValues.setConditions(this.rulesUtils.createVariousConditions());
        RestRuleModel rule = this.createAndSaveRule(ruleModelWithInitialValues);
        Step.STEP((String)"Try to update the rule and modify conditions.");
        RestCompositeConditionDefinitionModel compositeCondition = this.rulesUtils.createCompositeCondition(List.of(this.rulesUtils.createCompositeCondition(false, List.of(this.rulesUtils.createSimpleCondition("tag", "equals", "sample_tag")))));
        rule.setConditions(compositeCondition);
        RestRuleModel updatedRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleModel)updatedRule.assertThat().isEqualTo((Object)rule, new String[]{"id"})).assertThat().field("id").isNotNull();
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void updateRuleRemoveAllConditions() {
        RestRuleModel ruleModelWithInitialValues = this.rulesUtils.createRuleModelWithModifiedValues();
        ruleModelWithInitialValues.setConditions(this.rulesUtils.createVariousConditions());
        RestRuleModel rule = this.createAndSaveRule(ruleModelWithInitialValues);
        Step.STEP((String)"Try to update the rule and remove all conditions.");
        rule.setConditions(null);
        RestRuleModel updatedRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleModel)updatedRule.assertThat().isEqualTo((Object)rule, new String[]{"id"})).assertThat().field("id").isNotNull();
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void updateRuleWithInvalidCategoryInConditionAndFail() {
        RestRuleModel ruleModelWithInitialValues = this.rulesUtils.createRuleModelWithModifiedValues();
        ruleModelWithInitialValues.setConditions(this.rulesUtils.createVariousConditions());
        RestRuleModel rule = this.createAndSaveRule(ruleModelWithInitialValues);
        Step.STEP((String)"Try to update the rule with invalid condition.");
        RestCompositeConditionDefinitionModel conditions = this.rulesUtils.createCompositeCondition(List.of(this.rulesUtils.createCompositeCondition(false, List.of(this.rulesUtils.createSimpleCondition("category", "equals", "fake-category-id")))));
        rule.setConditions(conditions);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("Category in condition is invalid");
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void updateRuleWithConditionWithoutComparatorAndFail() {
        RestRuleModel ruleModelWithInitialValues = this.rulesUtils.createRuleModelWithModifiedValues();
        ruleModelWithInitialValues.setConditions(this.rulesUtils.createVariousConditions());
        RestRuleModel rule = this.createAndSaveRule(ruleModelWithInitialValues);
        Step.STEP((String)"Try to update the rule with invalid condition (null comparator when required non-null).");
        RestCompositeConditionDefinitionModel conditions = this.rulesUtils.createCompositeCondition(List.of(this.rulesUtils.createCompositeCondition(false, List.of(this.rulesUtils.createSimpleCondition("size", null, "65500")))));
        rule.setConditions(conditions);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("Comparator in condition must not be blank");
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void updateRuleWithConditionWithoutFieldAndFail() {
        RestRuleModel ruleModelWithInitialValues = this.rulesUtils.createRuleModelWithModifiedValues();
        ruleModelWithInitialValues.setConditions(this.rulesUtils.createVariousConditions());
        RestRuleModel rule = this.createAndSaveRule(ruleModelWithInitialValues);
        Step.STEP((String)"Try to update the rule with invalid condition (null field).");
        RestCompositeConditionDefinitionModel conditions = this.rulesUtils.createCompositeCondition(List.of(this.rulesUtils.createCompositeCondition(false, List.of(this.rulesUtils.createSimpleCondition(null, "greater_than", "65500")))));
        rule.setConditions(conditions);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("Field in condition must not be blank");
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void updateRuleWithConditionWithoutParamValueAndFail() {
        RestRuleModel ruleModelWithInitialValues = this.rulesUtils.createRuleModelWithModifiedValues();
        ruleModelWithInitialValues.setConditions(this.rulesUtils.createVariousConditions());
        RestRuleModel rule = this.createAndSaveRule(ruleModelWithInitialValues);
        Step.STEP((String)"Try to update the rule with invalid condition (null parameter).");
        RestCompositeConditionDefinitionModel conditions = this.rulesUtils.createCompositeCondition(List.of(this.rulesUtils.createCompositeCondition(false, List.of(this.rulesUtils.createSimpleCondition("size", "greater_than", "")))));
        rule.setConditions(conditions);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("Parameter in condition must not be blank");
    }

    @Test(groups={"rest-api", "rules"})
    public void updateRuleAddActions() {
        RestRuleModel rule = this.createAndSaveRule(this.rulesUtils.createRuleModelWithModifiedValues());
        Step.STEP((String)"Try to update the rule by adding several actions");
        RestActionBodyExecTemplateModel counterAction = this.rulesUtils.createCustomActionModel("counter", null);
        Map<String, String> addAspectParams = Map.of("aspect-name", "cm:taggable");
        RestActionBodyExecTemplateModel addAspectAction = this.rulesUtils.createCustomActionModel("add-features", addAspectParams);
        rule.setActions(Arrays.asList(counterAction, addAspectAction));
        RestRuleModel updatedRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleModel)updatedRule.assertThat().isEqualTo((Object)rule, new String[]{"id"})).assertThat().field("id").isNotNull();
    }

    @Test(groups={"rest-api", "rules"})
    public void updateRuleAddCheckoutActionForOutboundShouldFail() {
        RestRuleModel rule = this.createAndSaveRule(this.rulesUtils.createRuleModelWithModifiedValues());
        Step.STEP((String)"Try to update the rule by adding checkout action");
        Map<String, String> checkOutParams = Map.of("destination-folder", this.rulesUtils.getCheckOutDestinationFolder().getNodeRef(), "assoc-name", "cm:checkout", "assoc-type", "cm:contains");
        RestActionBodyExecTemplateModel checkOutAction = this.rulesUtils.createCustomActionModel("check-out", checkOutParams);
        rule.setActions(List.of(checkOutAction));
        UserModel admin = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(admin).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("Check out action cannot be performed for the rule type outbound!");
    }

    @Test(groups={"rest-api", "rules"})
    public void updateRuleAddActionWithInvalidParamShouldFail() {
        RestRuleModel rule = this.createAndSaveRule(this.rulesUtils.createRuleModelWithModifiedValues());
        Step.STEP((String)"Try to update the rule by adding action with invalid parameter (non-existing namespace in value)");
        RestActionBodyExecTemplateModel action = new RestActionBodyExecTemplateModel();
        action.setActionDefinitionId("add-features");
        String aspectNameParam = "aspect-name";
        String paramValue = "dummy:dummy";
        action.setParams(Map.of("aspect-name", "dummy:dummy"));
        rule.setActions(List.of(action));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary(String.format("Action parameter: %s has invalid value (%s). Look up possible values for constraint name %s", "aspect-name", "dummy:dummy", "ac-aspects"));
    }

    @Test
    public void updateRuleWithActions_userCannotUsePrivateAction() {
        Step.STEP((String)"Using admin create a rule with a private action.");
        RestRuleModel rule = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleWithPrivateAction());
        Step.STEP((String)"Try to update the rule with a normal user.");
        rule.setName("Updated name");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary("Only admin or system user is allowed to define uses of or directly execute this action");
    }

    @Test
    public void updateRuleWithActions_adminCanUsePrivateAction() {
        Step.STEP((String)"Using admin create a rule with a private action.");
        RestRuleModel rule = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleWithPrivateAction());
        Step.STEP((String)"Try to update the rule with the admin user.");
        rule.setName("Updated name");
        RestRuleModel updatedRule = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().updateRule(rule.getId(), rule);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        updatedRule.assertThat().field("name").is((Object)"Updated name");
    }

    private RestRuleModel createAndSaveRule(String name) {
        return this.createAndSaveRule(name, List.of(this.rulesUtils.createAddAudioAspectAction()));
    }

    private RestRuleModel createAndSaveRule(String name, List<RestActionBodyExecTemplateModel> restActionModels) {
        Step.STEP((String)("Create a rule called " + name + ", containing actions: " + String.valueOf(restActionModels)));
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel(name, restActionModels);
        return this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
    }

    private RestRuleModel createAndSaveRule(RestRuleModel ruleModel) {
        Step.STEP((String)("Create a rule: " + String.valueOf(ruleModel)));
        return this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
    }
}

