/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.nodes;

import io.restassured.RestAssured;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestNodeBodyMoveCopyModel;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.builder.NodesBuilder;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.junit.Assert;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class NodesTests
extends RestTest {
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify files can be moved from one folder to another")
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void testMoveFile() throws Exception {
        this.restClient.authenticateUser(this.dataContent.getAdminUser());
        NodesBuilder nodesBuilder = this.restClient.withCoreAPI().usingNode((RepoTestModel)ContentModel.my()).defineNodes();
        NodesBuilder.NodeDetail sourceFolder = nodesBuilder.folder("sourceFolder");
        NodesBuilder.NodeDetail file = sourceFolder.file("file");
        NodesBuilder.NodeDetail destinationFolder = nodesBuilder.folder("destinationFolder");
        RestNodeBodyMoveCopyModel moveDestinationInfo = new RestNodeBodyMoveCopyModel();
        moveDestinationInfo.setTargetParentId(destinationFolder.getId());
        ContentModel fileToMove = new ContentModel();
        fileToMove.setNodeRef(file.getId());
        RestNodeModel response = this.restClient.withParams(new String[]{"autoRename=true"}).withCoreAPI().usingNode((RepoTestModel)fileToMove).move(moveDestinationInfo);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        response.assertThat().field("parentId").is((Object)destinationFolder.getId());
    }

    @TestRail(section={"sanity"}, executionType={ExecutionType.SANITY}, description="Verify 403 is received for files where the user lacks permissions.")
    @Test(groups={"sanity"})
    public void siteConsumerWillGet403OnFileWithDisabledInherittedPermissions() throws Exception {
        UserModel adminUser = this.dataContent.getAdminUser();
        RestWrapper restWrapper = this.restClient.authenticateUser(adminUser);
        this.testSite = this.dataSite.createPublicRandomSite();
        FileModel file = ((DataContent)this.dataContent.usingUser(adminUser).usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        DataUser.ListUserWithRoles listUserWithRoles = ((DataUser)this.dataUser.usingUser(adminUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteConsumer});
        JsonObject activateModelJson = Json.createObjectBuilder().add("permissions", Json.createObjectBuilder().add("isInheritanceEnabled", false)).build();
        restWrapper.withCoreAPI().usingNode((RepoTestModel)file).updateNode(activateModelJson.toString());
        restWrapper.assertStatusCodeIs(HttpStatus.OK);
        UserModel consumerUser = listUserWithRoles.getOneUserWithRole(UserRole.SiteConsumer);
        RestResponse restApiResponse = this.restClient.authenticateUser(consumerUser).withCoreAPI().usingNode((RepoTestModel)file).getNodeContent();
        int restApiStatusCode = restApiResponse.getResponse().getStatusCode();
        this.logger.info((Object)("REST API call response status code is: " + restApiStatusCode));
        Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)restApiStatusCode);
        RestAssured.basePath = "alfresco/api/-default-/public/cmis/versions/1.1/browser";
        restWrapper.configureRequestSpec().setBasePath(RestAssured.basePath);
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)("/root/Sites/" + this.testSite.getTitle() + "/documentLibrary/" + file.getName() + "?cmisselector=object&succinct=true"), (String[])new String[0]);
        RestResponse cmisApiResponse = restWrapper.authenticateUser(consumerUser).process(request);
        int cmisApiStatusCode = cmisApiResponse.getResponse().getStatusCode();
        this.logger.info((Object)("CMIS API call response status code is: " + cmisApiStatusCode));
        Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)cmisApiStatusCode);
    }
}

