/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.deployments;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class GetDeploymentsCoreTests
extends RestTest {
    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.REGRESSION}, description="Verify non admin user is not able to get non-network deployments using REST API and status code is Forbidden")
    @Test(groups={"rest-api", "workflow", "deployments", "regression"})
    public void nonAdminUserCanNotGetNonNetworkDeployments() throws Exception {
        UserModel userModel = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(userModel).withWorkflowAPI().getDeployments();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }
}

