/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.ratings;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestRatingModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataLink;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.LinkModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddRatingTests
extends RestTest {
    private UserModel userModel;
    private SiteModel siteModel;
    private UserModel adminUser;
    private DataUser.ListUserWithRoles usersWithRoles;
    private RestRatingModel returnedRatingModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.userModel = this.dataUser.createRandomTestUser();
        this.adminUser = this.dataUser.getAdminUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.SANITY}, description="Verify user with Manager role is able to post like rating to a document")
    @Test(groups={"rest-api", "ratings", "sanity"})
    public void managerIsAbleToLikeDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role is able to post like rating to a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void collaboratorIsAbleToLikeDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role is able to post like rating to a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void contributorIsAbleToLikeDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role is able to post like rating to a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void consumerIsAbleToLikeDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user is able to post like rating to a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void adminIsAbleToLikeDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.SANITY}, description="Verify unauthenticated user is not able to post like rating to a document")
    @Test(groups={"rest-api", "ratings", "sanity"})
    public void unauthenticatedUserIsNotAbleToLikeDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(new UserModel("random user", "random password")).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.SANITY}, description="Verify user with Manager role is able to post stars rating to a document")
    @Test(groups={"rest-api", "ratings", "sanity"})
    public void managerIsAbleToAddStarsToDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role is able to post stars rating to a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void collaboratorIsAbleToAddStarsToDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role is able to post stars rating to a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void contributorIsAbleToAddStarsToDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role is able to post stars rating to a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void consumerIsAbleToAddStarsToDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "regression"}, executionType={ExecutionType.SANITY}, description="Verify admin user is able to post stars rating to a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void adminIsAbleToAddStarsToDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(3);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"3")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.SANITY}, description="Verify unauthenticated user is not able to post stars rating to a document")
    @Test(groups={"rest-api", "ratings", "sanity"})
    public void unauthenticatedUserIsNotAbleToRateStarsToDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(new UserModel("random user", "random password")).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that if unknown rating scheme is provided status code is 400")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void unknownRatingSchemeReturnsBadRequest() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addInvalidRating("{\"id\":\"invalidRate\"}");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_RATING, "invalidRate")).containsErrorKey(String.format(RestErrorModel.INVALID_RATING, "invalidRate")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that if nodeId does not exist status code 404 is returned")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void invalidNodeIdReturnsNotFound() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        document.setNodeRef(RandomStringUtils.randomAlphanumeric((int)10));
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, document.getNodeRef())).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that if nodeId provided cannot be rated 405 status code is returned")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void likeResourceThatCannotBeRated() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        LinkModel link = ((DataLink)((DataLink)this.dataLink.usingAdmin()).usingSite(this.siteModel)).createRandomLink();
        document.setNodeRef(link.getNodeRef().replace("workspace://SpacesStore/", "workspace%3A%2F%2FSpacesStore%2F"));
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, document.getNodeRef())).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.SANITY}, description="Verify that manager is able to like a folder")
    @Test(groups={"rest-api", "ratings", "sanity"})
    public void managerIsAbleToLikeAFolder() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)folderModel).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.SANITY}, description="Verify that manager is able to like a site")
    @Test(groups={"rest-api", "ratings", "sanity"})
    public void managerIsAbleToLikeASite() throws Exception {
        FolderModel folderModel = new FolderModel();
        folderModel.setNodeRef(this.siteModel.getGuid());
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)folderModel).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).getRatings().assertNodeIsLiked();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.SANITY}, description="Verify that manager is able to rate a folder")
    @Test(groups={"rest-api", "ratings", "sanity"})
    public void managerIsAbleToRateAFolder() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)folderModel).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "sanity"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager is able to rate a site")
    @Test(groups={"rest-api", "ratings", "sanity"})
    public void managerIsAbleToRateASite() throws Exception {
        FolderModel folderModel = new FolderModel();
        folderModel.setNodeRef(this.siteModel.getGuid());
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)folderModel).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).getRatings().assertNodeHasFiveStarRating();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that adding like again has no effect on a file")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void fileCanBeLikedTwice() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.returnedRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that adding rate again has no effect on a file")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void fileCanBeRatedTwice() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.returnedRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that rate is not added if empty rating object is provided")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addRateUsingEmptyRatingObject() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addInvalidRating("");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "No content to map due to end-of-input"));
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that if empty rate id is provided status code is 400")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addRateUsingEmptyValueForId() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addInvalidRating("{\"id\":\"\"}");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "N/A"));
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that if empty rating is provided status code is 400")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addRateUsingEmptyValueForMyRating() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addInvalidRating("{\"id\":\"likes\", \"myRating\":\"\"}");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NULL_LIKE_RATING, new Object[0]));
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addInvalidRating("{\"id\":\"fiveStar\", \"myRating\":\"\"}");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NULL_FIVESTAR_RATING, new Object[0]));
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that user is not able to rate a comment")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addRatingToAComment() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestCommentModel comment = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addComment("This is a comment");
        document.setNodeRef(comment.getId());
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(String.format(RestErrorModel.CANNOT_RATE, new Object[0])).containsErrorKey(RestErrorModel.CANNOT_RATE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(String.format(RestErrorModel.CANNOT_RATE, new Object[0]));
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that user is not able to rate a tag")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addRatingToATag() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestTagModel tag = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addTag("randomTag");
        document.setNodeRef(tag.getId());
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(String.format(RestErrorModel.CANNOT_RATE, new Object[0]));
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(String.format(RestErrorModel.CANNOT_RATE, new Object[0]));
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that Contributor is able to like a folder")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void contributorIsAbleToLikeAFolder() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingResource((RepoTestModel)folderModel).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that Collaborator is able to like a folder")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void collaboratorIsAbleToLikeAFolder() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)folderModel).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that Consumer is able to like a folder")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void consumerIsAbleToLikeAFolder() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingResource((RepoTestModel)folderModel).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that Contributor is able to rate a folder")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void contributorIsAbleToRateAFolder() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingResource((RepoTestModel)folderModel).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that Collaborator is able to rate a folder")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void collaboratorIsAbleToRateAFolder() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)folderModel).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that Consumer is able to rate a folder")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void consumerIsAbleToRateAFolder() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingResource((RepoTestModel)folderModel).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that adding like again has no effect on a folder")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void folderCanBeLikedTwice() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folderModel).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.returnedRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folderModel).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that adding rate again has no effect on a folder")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void folderCanBeRatedTwice() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folderModel).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.returnedRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folderModel).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that if invalid rate id is provided status code is 400")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addRateUsingInvalidValueForId() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addInvalidRating("{\"id\":\"like\"}");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_RATING, "like")).containsErrorKey(String.format(RestErrorModel.INVALID_RATING, "like")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that rate id is case sensitive is provided status code is 400")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addRateUsingInvalidValueForIdCaseSensitive() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addInvalidRating("{\"id\":\"Likes\"}");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_RATING, "Likes")).containsErrorKey(String.format(RestErrorModel.INVALID_RATING, "Likes")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addInvalidRating("{\"id\":\"FiveStar\"}");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_RATING, "FiveStar")).containsErrorKey(String.format(RestErrorModel.INVALID_RATING, "FiveStar")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that if invalid rating is provided status code is 400")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addRateUsingInvalidValueForMyRating() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addInvalidRating("{\"id\":\"likes\", \"myRating\":\"skiped\"}");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NULL_LIKE_RATING, new Object[0]));
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addInvalidRating("{\"id\":\"fiveStar\", \"myRating\":\"string\"}");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NULL_FIVESTAR_RATING, new Object[0]));
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Like file created by a different user")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addLikeToAnotherUserFile() throws Exception {
        UserModel user = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedRatingModel = this.restClient.authenticateUser(user).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Rate a file created by a different user")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addRatingToAnotherUserFile() throws Exception {
        UserModel user = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedRatingModel = this.restClient.authenticateUser(user).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Add Rate Using Boolean Value For 'myRating'")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addRateUsingBooleanValueForMyRating() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addInvalidRating("{\"id\":\"fiveStar\", \"myRating\":\"true\"}");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NULL_FIVESTAR_RATING).containsErrorKey(RestErrorModel.NULL_FIVESTAR_RATING).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Add Like Using Integer Value For 'myRating'")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addLikeUsingIntegerValueForMyRating() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addInvalidRating("{\"id\":\"likes\", \"myRating\":\"2\"}");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NULL_LIKE_RATING).containsErrorKey(RestErrorModel.NULL_LIKE_RATING).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that user is not able to like his own comment")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void userCannotLikeHisOwnComment() throws Exception {
        UserModel user = this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(user).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(user).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestCommentModel comment = this.restClient.authenticateUser(user).withCoreAPI().usingResource((RepoTestModel)document).addComment("This is a comment");
        document.setNodeRef(comment.getId());
        this.returnedRatingModel = this.restClient.authenticateUser(user).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(String.format(RestErrorModel.CANNOT_RATE, new Object[0])).containsErrorKey(RestErrorModel.CANNOT_RATE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that user is not able to rate his own comment")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void userCannotRateHisOwnComment() throws Exception {
        UserModel user = this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(user).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(user).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestCommentModel comment = this.restClient.authenticateUser(user).withCoreAPI().usingResource((RepoTestModel)document).addComment("This is a comment");
        document.setNodeRef(comment.getId());
        this.returnedRatingModel = this.restClient.authenticateUser(user).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(String.format(RestErrorModel.CANNOT_RATE, new Object[0])).containsErrorKey(RestErrorModel.CANNOT_RATE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that Collaborator is NOT able to add a negative rating to a file")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void collaboratorIsNotAbleToAddANegativeRatingToAFile() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(-5);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.RATING_OUT_OF_BOUNDS).containsErrorKey(RestErrorModel.RATING_OUT_OF_BOUNDS).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that Collaborator is NOT able to add a high rating to a file")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void collaboratorIsNotAbleToAddAHighRatingToAFile() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedRatingModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(10);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.RATING_OUT_OF_BOUNDS).containsErrorKey(RestErrorModel.RATING_OUT_OF_BOUNDS).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Do not provide field - 'id'")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void notProvideIdLikeFile() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addInvalidRating("{\"myRating\":\"true\"}");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_RATING, "null")).containsErrorKey(String.format(RestErrorModel.INVALID_RATING, "null")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Do not provide field - 'myRating'")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void notProvideMyRatingRateFile() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.userModel).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).addInvalidRating("{\"id\":\"likes\"}");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NULL_LIKE_RATING).containsErrorKey(RestErrorModel.NULL_LIKE_RATING).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

