/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.actions.access;

import io.restassured.response.ValidatableResponse;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.actions.access.AccessRestrictionUtil;
import org.alfresco.rest.actions.access.pojo.Rule;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.UserModel;
import org.hamcrest.Matchers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RuleAdminAccessRestrictionTest
extends RestTest {
    private static final String CREATE_RULE_ENDPOINT = "alfresco/service/api/node/workspace/SpacesStore/%s/ruleset/rules";
    private UserModel adminUser;
    private UserModel testUser;
    private FolderModel testFolder;
    @Autowired
    protected RestWrapper restClient;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
    }

    @BeforeMethod(alwaysRun=true)
    public void setup() {
        this.restClient.configureRequestSpec().setBasePath("");
    }

    @Test
    public void userShouldNotBeAbleToCreateANewRule() {
        this.restClient.authenticateUser(this.testUser);
        Rule rule = AccessRestrictionUtil.createRuleWithAction("mail", AccessRestrictionUtil.createMailParameters(this.adminUser, this.testUser));
        String ruleRequestBody = AccessRestrictionUtil.mapObjectToJSON(rule);
        String ruleEndpoint = String.format(CREATE_RULE_ENDPOINT, this.testFolder.getNodeRef());
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)ruleRequestBody, (String)ruleEndpoint, (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        ((ValidatableResponse)((ValidatableResponse)response.assertThat().statusCode(HttpStatus.INTERNAL_SERVER_ERROR.value())).assertThat()).body("message", Matchers.containsString((String)"Only admin or system user is allowed to define uses of or directly execute this action"), new Object[0]);
    }

    @Test
    public void adminShouldBeAbleToCreateANewRule() {
        this.restClient.authenticateUser(this.adminUser);
        Rule rule = AccessRestrictionUtil.createRuleWithAction("mail", AccessRestrictionUtil.createMailParameters(this.adminUser, this.testUser));
        String ruleRequestBody = AccessRestrictionUtil.mapObjectToJSON(rule);
        String ruleEndpoint = String.format(CREATE_RULE_ENDPOINT, this.testFolder.getNodeRef());
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)ruleRequestBody, (String)ruleEndpoint, (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        response.assertThat().statusCode(HttpStatus.OK.value());
    }

    @Test
    public void userShouldAddAFileToFolderWithMailRule() {
        this.restClient.authenticateUser(this.adminUser);
        Rule rule = AccessRestrictionUtil.createRuleWithAction("mail", AccessRestrictionUtil.createMailParameters(this.adminUser, this.testUser));
        String ruleRequestBody = AccessRestrictionUtil.mapObjectToJSON(rule);
        String ruleEndpoint = String.format(CREATE_RULE_ENDPOINT, this.testFolder.getNodeRef());
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)ruleRequestBody, (String)ruleEndpoint, (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        response.assertThat().statusCode(HttpStatus.OK.value());
        ((DataContent)((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).usingResource((ContentModel)this.testFolder)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
    }
}

