/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.membershipRequests;

import org.alfresco.dataprep.SiteService;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteEntry;
import org.alfresco.rest.model.RestSiteMembershipRequestModel;
import org.alfresco.rest.model.RestSiteMembershipRequestModelsCollection;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddSiteMembershipRequestTests
extends RestTest {
    private SiteModel publicSite;
    private SiteModel anotherPublicSite;
    private SiteModel moderatedSite;
    private SiteModel privateSite;
    private DataUser.ListUserWithRoles usersWithRoles;
    private UserModel adminUser;
    private UserModel siteManager;
    private UserModel regularUser;
    private UserModel newMember;
    private RestSiteMembershipRequestModel siteMembershipRequest;
    private RestSiteMembershipRequestModelsCollection siteMembershipRequests;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUser = this.dataUser.getAdminUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.siteManager = this.dataUser.createRandomTestUser();
        this.anotherPublicSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.moderatedSite = ((DataSite)this.dataSite.usingUser(this.adminUser)).createModeratedRandomSite();
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPrivateRandomSite();
        this.newMember = this.dataUser.createRandomTestUser();
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to create new site membership request for himself and status code is 201")
    public void managerCreatesNewSiteMembershipRequestForSelf() throws Exception {
        this.siteMembershipRequest = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.anotherPublicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)this.siteMembershipRequest.assertThat().field("id").is((Object)this.anotherPublicSite.getId())).assertThat().field("site").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to create new site membership request for himself and status code is 201")
    public void contributorCreatesNewSiteMembershipRequestForSelf() throws Exception {
        this.siteMembershipRequest = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.anotherPublicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)this.siteMembershipRequest.assertThat().field("id").is((Object)this.anotherPublicSite.getId())).assertThat().field("site").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to create new site membership request for himself and status code is 201")
    public void collaboratorCreatesNewSiteMembershipRequestForSelf() throws Exception {
        this.siteMembershipRequest = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.anotherPublicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)this.siteMembershipRequest.assertThat().field("id").is((Object)this.anotherPublicSite.getId())).assertThat().field("site").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is able to create new site membership request for himself and status code is 201")
    public void consumerCreatesNewSiteMembershipRequestForSelf() throws Exception {
        this.siteMembershipRequest = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.anotherPublicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)this.siteMembershipRequest.assertThat().field("id").is((Object)this.anotherPublicSite.getId())).assertThat().field("site").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to create new site membership request for himself and status code is 201")
    public void adminCreatesNewSiteMembershipRequestForSelf() throws Exception {
        this.siteMembershipRequest = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.anotherPublicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)this.siteMembershipRequest.assertThat().field("id").is((Object)this.anotherPublicSite.getId())).assertThat().field("site").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify unauthenticated user is not able to create new site membership request")
    public void unauthenticatedUserIsNotAbleToCreateSiteMembershipRequest() throws Exception {
        this.restClient.authenticateUser(new UserModel("random user", "random password")).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify addSiteMembershipRequest Rest API status code is 400 for a user that has already been invited")
    public void addSiteMembershipRequestStatusCodeIs400ReceivedForAUserThatIsAlreadyInvited() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(newMember, this.moderatedSite, UserRole.SiteContributor);
        this.restClient.authenticateUser(newMember).withCoreAPI().usingMe().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary(String.format(RestErrorModel.ALREADY_Site_MEMBER, newMember.getUsername(), this.moderatedSite.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify addSiteMembershipRequest Rest API status code is 404 for a user that does not exist")
    public void addSiteMembershipRequestStatusCodeIs404ReceivedForAUserThatDoesNotExist() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingUser(new UserModel("invalidUser", "password")).addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.restClient.assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidUser"));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify addSiteMembershipRequest Rest API status code is 404 for a site that does not exist")
    public void addSiteMembershipRequestStatusCodeIs404ReceivedForASiteThatDoesNotExist() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingMe().addSiteMembershipRequest(new SiteModel("invalidSiteID"));
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.restClient.assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, newMember.getUsername(), "invalidSiteID"));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify addSiteMembershipRequest Rest API status code is 400 for empty request body")
    public void addSiteMembershipRequestStatusCodeIs400ForEmptyRequestBody() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingMe().addSiteMembershipRequest("");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "No content to map due to end-of-input"));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify addSiteMembershipRequest Rest API status code is 201 for request with empty message")
    public void addSiteMembershipRequestStatusCodeIs201ForRequestWithEmptyMessage() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.siteMembershipRequest = this.restClient.authenticateUser(newMember).withCoreAPI().usingMe().addSiteMembershipRequest("", this.moderatedSite, "New request");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)this.siteMembershipRequest.assertThat().field("id").is((Object)this.moderatedSite.getId())).assertThat().field("site").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify addSiteMembershipRequest Rest API status code is 201 for request with empty title")
    public void addSiteMembershipRequestStatusCodeIs201ForRequestWithEmptyTitle() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.siteMembershipRequest = this.restClient.authenticateUser(newMember).withCoreAPI().usingMe().addSiteMembershipRequest("Please accept me", this.moderatedSite, "");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)this.siteMembershipRequest.assertThat().field("id").is((Object)this.moderatedSite.getId())).assertThat().field("site").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to create new site membership request for other user")
    public void managerIsNotAbleToCreateSiteMembershipRequestForOtherUser() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingUser(this.newMember).addSiteMembershipRequest(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.newMember.getUsername())).statusCodeIs(HttpStatus.NOT_FOUND).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is not able to create new site membership request for other user")
    public void collaboratorIsNotAbleToCreateSiteMembershipRequestForOtherUser() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingUser(this.newMember).addSiteMembershipRequest(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.newMember.getUsername()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is not able to create new site membership request for other user")
    public void contributorIsNotAbleToCreateSiteMembershipRequestForOtherUser() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingUser(this.newMember).addSiteMembershipRequest(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.newMember.getUsername()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is not able to create new site membership request for other user")
    public void consumerIsNotAbleToCreateSiteMembershipRequestForOtherUser() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingUser(this.newMember).addSiteMembershipRequest(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.newMember.getUsername()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user is not able to create new site membership request for other user")
    public void adminIsNotAbleToCreateSiteMembershipRequestForOtherUser() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(this.newMember).addSiteMembershipRequest(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.newMember.getUsername()));
        this.restClient.withCoreAPI().usingUser(this.newMember).addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.newMember.getUsername()));
        this.restClient.withCoreAPI().usingUser(this.newMember).addSiteMembershipRequest(this.privateSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.newMember.getUsername()));
    }

    @Bug(id="ACE-2413")
    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify addSiteMembershipRequest Rest API status code is 400 for an invalid user id")
    public void addSiteMembershipRequestReturns400ForEmptyUserId() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(new UserModel("", "password")).addSiteMembershipRequest(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify regular user is able to create new public site membership request for himself. Check that user joins immediately as consumer.")
    public void userIsAbleToRequestMembershipOfPublicSite() throws Exception {
        this.regularUser = this.dataUser.createRandomTestUser();
        this.siteMembershipRequest = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)this.siteMembershipRequest.assertThat().field("id").is((Object)this.publicSite.getId())).assertThat().field("site").isNotEmpty();
        RestSiteEntry siteEntry = this.restClient.withCoreAPI().usingAuthUser().getSiteMembership(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteEntry)siteEntry.assertThat().field("role").is((Object)UserRole.SiteConsumer)).and().field("id").is((Object)this.publicSite.getId());
        this.siteMembershipRequests = this.restClient.withCoreAPI().usingAuthUser().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembershipRequests.assertThat().entriesListIsEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify regular user is able to create new moderated site membership request for himself. Check that the request is added to the site membership request list.")
    public void userIsAbleToRequestMembershipOfModeratedSite() throws Exception {
        this.regularUser = this.dataUser.createRandomTestUser();
        this.siteMembershipRequest = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)this.siteMembershipRequest.assertThat().field("id").is((Object)this.moderatedSite.getId())).assertThat().field("message").is((Object)"Please accept me")).assertThat().field("site").isNotEmpty();
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)this.siteMembershipRequest.getSite().assertThat().field("visibility").is((Object)this.moderatedSite.getVisibility())).assertThat().field("guid").is((Object)this.moderatedSite.getGuid())).assertThat().field("description").is((Object)this.moderatedSite.getDescription())).assertThat().field("id").is((Object)this.moderatedSite.getId())).assertThat().field("title").is((Object)this.moderatedSite.getTitle());
        this.siteMembershipRequests = this.restClient.withCoreAPI().usingAuthUser().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.siteMembershipRequests.assertThat().entriesListContains("id", this.moderatedSite.getId())).assertThat().entriesListCountIs(1);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify regular user is not able to request membership of a private site.")
    public void userIsNotAbleToRequestMembershipOfPrivateSite() throws Exception {
        this.regularUser = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.privateSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.regularUser.getUsername(), this.privateSite.getId()));
        this.siteMembershipRequests = this.restClient.withCoreAPI().usingAuthUser().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembershipRequests.assertThat().entriesListIsEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify regular user is not able to create new site membership request for other user")
    public void regularUserIsNotAbleToCreateSiteMembershipRequestForOtherUser() throws Exception {
        this.regularUser = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingUser(this.newMember).addSiteMembershipRequest(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.newMember.getUsername()));
        this.restClient.withCoreAPI().usingUser(this.newMember).addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.newMember.getUsername()));
        this.restClient.withCoreAPI().usingUser(this.newMember).addSiteMembershipRequest(this.privateSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.newMember.getUsername()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify create public site membership request returns status code 400 when the request is made twice")
    public void userRequestsTwiceMembershipOfPublicSite() throws Exception {
        this.regularUser = this.dataUser.createRandomTestUser();
        this.siteMembershipRequest = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)this.siteMembershipRequest.assertThat().field("id").is((Object)this.publicSite.getId())).assertThat().field("site").isNotEmpty();
        this.restClient.withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary(String.format(RestErrorModel.ALREADY_Site_MEMBER, this.regularUser.getUsername(), this.publicSite.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify create moderated site membership request returns status code 400 when the request is made twice")
    public void userRequestsTwiceMembershipOfModeratedSite() throws Exception {
        this.regularUser = this.dataUser.createRandomTestUser();
        this.siteMembershipRequest = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)this.siteMembershipRequest.assertThat().field("id").is((Object)this.moderatedSite.getId())).assertThat().field("site").isNotEmpty();
        this.restClient.withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary(String.format(RestErrorModel.ALREADY_INVITED, this.regularUser.getUsername(), this.moderatedSite.getId()));
        this.siteMembershipRequests = this.restClient.withCoreAPI().usingAuthUser().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.siteMembershipRequests.assertThat().entriesListContains("id", this.moderatedSite.getId())).assertThat().entriesListCountIs(1);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify create private site membership request returns status code 404 when request is made with the user who created the site")
    public void siteCreatorRequestsMembershipOfHisPrivateSite() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.privateSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.adminUser.getUsername(), this.privateSite.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify create moderated site membership request returns status code 400 when request is made with the user who created the site")
    public void siteCreatorRequestsMembershipOfHisModeratedSite() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.ALREADY_Site_MEMBER, this.adminUser.getUsername(), this.moderatedSite.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to create new moderated site membership request for himself. Check that the request is added to the site membership request list.")
    public void adminIsAbleToRequestMembershipOfModeratedSite() throws Exception {
        this.regularUser = this.dataUser.createRandomTestUser();
        SiteModel anotherModeratedSite = ((DataSite)this.dataSite.usingUser(this.regularUser)).createModeratedRandomSite();
        this.siteMembershipRequest = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(anotherModeratedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)this.siteMembershipRequest.assertThat().field("id").is((Object)anotherModeratedSite.getId())).assertThat().field("site").isNotEmpty();
        this.siteMembershipRequests = this.restClient.withCoreAPI().usingAuthUser().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembershipRequests.assertThat().entriesListContains("id", anotherModeratedSite.getId());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site membership request is automatically rejected when a site is switched from moderated to private")
    public void siteMembershipRequestIsRejectedWhenSiteIsSwitchedFromModeratedToPrivate() throws Exception {
        this.regularUser = this.dataUser.createRandomTestUser();
        SiteModel moderatedThenPrivateSite = ((DataSite)this.dataSite.usingUser(this.adminUser)).createModeratedRandomSite();
        this.siteMembershipRequest = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingMe().addSiteMembershipRequest(moderatedThenPrivateSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)this.siteMembershipRequest.assertThat().field("id").is((Object)moderatedThenPrivateSite.getId())).assertThat().field("site").isNotEmpty();
        ((DataSite)this.dataSite.usingUser(this.adminUser)).updateSiteVisibility(moderatedThenPrivateSite, SiteService.Visibility.PRIVATE);
        this.siteMembershipRequests = this.restClient.withCoreAPI().usingAuthUser().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembershipRequests.assertThat().entriesListIsEmpty();
    }
}

