/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rules;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.alfresco.rest.model.RestRuleModel;
import org.alfresco.rest.model.RestRuleModelsCollection;
import org.alfresco.rest.requests.FolderRules;
import org.alfresco.rest.rules.RulesRestTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.junit.Assert;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"rules"})
public class GetRulesTests
extends RulesRestTest {
    private UserModel user;
    private SiteModel site;
    private FolderModel ruleFolder;
    private List<RestRuleModel> createdRules;
    private RestRuleModel createdRuleA;
    private static final String IGNORE_ID = "id";
    private static final String IGNORE_IS_SHARED = "isShared";
    private static final String ACTIONS = "actions";
    private static final String CONDITIONS = "conditions";

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        Step.STEP((String)"Create a user, site and folder");
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        this.ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Create rules in the folder");
        this.createdRules = Stream.of("ruleA", "ruleB").map(ruleName -> {
            RestRuleModel ruleModel = this.rulesUtils.createRuleModel((String)ruleName);
            return this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        }).collect(Collectors.toList());
        this.createdRuleA = this.createdRules.get(0);
    }

    @Test(groups={"rest-api", "rules"})
    public void getEmptyRulesList() {
        Step.STEP((String)"Create a folder in existing site");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Get the rules that apply to the folder");
        RestRuleModelsCollection rules = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().getListOfRules();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        Assert.assertTrue((String)"Expected no rules to be present.", (boolean)rules.isEmpty());
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void getRulesList() {
        Step.STEP((String)"Get the rules that apply to the folder");
        RestRuleModelsCollection rules = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().getListOfRules();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        rules.assertThat().entriesListCountIs(this.createdRules.size());
        IntStream.range(0, this.createdRules.size()).forEach(i -> ((RestRuleModel)((RestRuleModel)((RestRuleModel)rules.getEntries().get(i)).onModel().assertThat().field(IGNORE_ID).is((Object)this.createdRules.get(i).getId())).assertThat().field("name").is((Object)this.createdRules.get(i).getName())).assertThat().field(IGNORE_IS_SHARED).isNull());
    }

    @Test(groups={"rest-api", "rules"})
    public void getRulesForNonExistentFolder() {
        Step.STEP((String)"Try to load rules for a non-existent folder.");
        FolderModel nonExistentFolder = FolderModel.getRandomFolderModel();
        nonExistentFolder.setNodeRef("fake-id");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)nonExistentFolder).usingDefaultRuleSet().getListOfRules();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "rules"})
    public void getRulesFromNonExistentRuleSet() {
        Step.STEP((String)"Create a folder in existing site");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Try to load rules for a non-existent rule set.");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).usingRuleSet("fake-id").getListOfRules();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void getRulesListWithIncludedFields() {
        Step.STEP((String)"Get the rules that apply to the folder");
        RestRuleModelsCollection rules = ((FolderRules)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().include(new String[]{IGNORE_IS_SHARED})).getListOfRules();
        rules.assertThat().entriesListCountIs(this.createdRules.size());
        IntStream.range(0, this.createdRules.size()).forEach(i -> ((RestRuleModel)((RestRuleModel)((RestRuleModel)((RestRuleModel)((RestRuleModel)((RestRuleModel)((RestRuleModel)((RestRuleModel)rules.getEntries().get(i)).onModel().assertThat().field(IGNORE_IS_SHARED).isNotNull()).assertThat().field("description").isNull()).assertThat().field("isEnabled").is((Object)true)).assertThat().field("isInheritable").is((Object)false)).assertThat().field("isAsynchronous").is((Object)false)).assertThat().field("errorScript").isNull()).assertThat().field(IGNORE_IS_SHARED).is((Object)false)).assertThat().field("triggers").is((Object)"[inbound]"));
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void getSingleRule() {
        Step.STEP((String)"Load a particular rule");
        RestRuleModel rule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().getSingleRule(this.createdRuleA.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleModel)((RestRuleModel)rule.assertThat().field(IGNORE_ID).is((Object)this.createdRuleA.getId())).assertThat().field("name").is((Object)this.createdRuleA.getName())).assertThat().field(IGNORE_IS_SHARED).isNull();
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void getRulesOtherFieldsModified() {
        Step.STEP((String)"Create a rule with all other fields default values modified");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithModifiedValues();
        ruleModel.setTriggers(List.of("update"));
        UserModel admin = this.dataUser.getAdminUser();
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        RestRuleModel rule = this.restClient.authenticateUser(admin).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().createSingleRule(ruleModel);
        RestRuleModel expectedRuleModel = this.rulesUtils.createRuleModelWithModifiedValues();
        expectedRuleModel.setTriggers(List.of("update"));
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRuleModel)((RestRuleModel)rule.assertThat().isEqualTo((Object)expectedRuleModel, new String[]{IGNORE_ID, IGNORE_IS_SHARED})).assertThat().field(IGNORE_ID).isNotNull()).assertThat().field(IGNORE_IS_SHARED).isNull();
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void getRulesDefaultFields() {
        Step.STEP((String)"Create a rule with all other fields default values");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        UserModel admin = this.dataUser.getAdminUser();
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        RestRuleModel rule = this.restClient.authenticateUser(admin).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().createSingleRule(ruleModel);
        RestRuleModel expectedRuleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        expectedRuleModel.setTriggers(List.of("inbound"));
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRuleModel)((RestRuleModel)rule.assertThat().isEqualTo((Object)expectedRuleModel, new String[]{IGNORE_ID, IGNORE_IS_SHARED})).assertThat().field(IGNORE_ID).isNotNull()).assertThat().field(IGNORE_IS_SHARED).isNull();
    }

    @Test(groups={"rest-api", "rules"})
    public void getSingleRuleFromNonExistentFolder() {
        Step.STEP((String)"Try to load a rule from a non-existent folder.");
        FolderModel nonExistentFolder = FolderModel.getRandomFolderModel();
        nonExistentFolder.setNodeRef("fake-id");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)nonExistentFolder).usingDefaultRuleSet().getSingleRule("fake-rule-id");
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "rules"})
    public void getSingleRuleFromNonExistentRuleSet() {
        Step.STEP((String)"Create a folder in existing site");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Try to load rules for a non-existent rule set.");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).usingRuleSet("fake-id").getSingleRule("fake-rule-id");
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "rules"})
    public void getSingleRuleFromWrongFolder() {
        Step.STEP((String)"Create a folder in existing site");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Try to load a rule for a wrong but existing folder.");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().getSingleRule(this.createdRuleA.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void getSingleRuleWithIncludedFields() {
        Step.STEP((String)"Load a particular rule");
        RestRuleModel rule = ((FolderRules)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().include(new String[]{IGNORE_IS_SHARED})).getSingleRule(this.createdRuleA.getId());
        rule.assertThat().field(IGNORE_IS_SHARED).isNotNull();
    }

    public void requireReadPermissionToGetRule() {
        Step.STEP((String)"Create a user and use them to create a private site containing a folder with a rule");
        UserModel privateUser = this.dataUser.createRandomTestUser();
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(privateUser)).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingUser(privateUser).usingSite(privateSite)).createFolder();
        RestRuleModel ruleModel = new RestRuleModel();
        ruleModel.setName("Private site rule");
        this.restClient.authenticateUser(privateUser).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Try to get the rule with another user");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().getListOfRules();
        this.restClient.assertLastError().statusCodeIs(HttpStatus.FORBIDDEN).containsSummary("Cannot read from this node");
    }

    public void dontRequireWritePermissionToGetRule() {
        Step.STEP((String)"Create a user and use them to create a private site containing a folder with a rule");
        UserModel privateUser = this.dataUser.createRandomTestUser();
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(privateUser)).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingUser(privateUser).usingSite(privateSite)).createFolder();
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel("Private site rule");
        this.restClient.authenticateUser(privateUser).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Create a collaborator in the private site");
        UserModel collaborator = this.dataUser.createRandomTestUser();
        collaborator.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(privateUser).withCoreAPI().usingSite(privateSite).addPerson(collaborator);
        Step.STEP((String)"Check the collaborator can view the rule");
        RestRuleModelsCollection rules = this.restClient.authenticateUser(collaborator).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().getListOfRules();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        rules.assertThat().entriesListContains("name", "Private site rule");
    }

    @Test(groups={"rest-api", "rules"})
    public void getRuleActions() {
        Step.STEP((String)"Create a rule with a few actions");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        RestRuleModel ruleWithVariousActions = this.rulesUtils.createRuleWithVariousActions();
        UserModel admin = this.dataUser.getAdminUser();
        RestRuleModel rule = this.restClient.authenticateUser(admin).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().createSingleRule(ruleWithVariousActions);
        Step.STEP((String)"Retrieve the created rule via the GET endpoint");
        RestRuleModel getRuleBody = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().getSingleRule(rule.getId());
        Step.STEP((String)"Assert that actions are returned as expected from the GET endpoint");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleModel)((RestRuleModel)((RestRuleModel)((RestRuleModel)((RestRuleModel)getRuleBody.assertThat().field(ACTIONS).contains("actionDefinitionId=copy")).assertThat().field(ACTIONS).contains("destination-folder=" + this.rulesUtils.getCopyDestinationFolder().getNodeRef())).assertThat().field(ACTIONS).contains("deep-copy=true")).assertThat().field(ACTIONS).contains("actionDefinitionId=check-out")).assertThat().field(ACTIONS).contains("destination-folder=" + this.rulesUtils.getCheckOutDestinationFolder().getNodeRef())).assertThat().field(ACTIONS).contains("assoc-name=cm:checkout");
    }

    @Test(groups={"rest-api", "rules"})
    public void getRulesConditions() {
        Step.STEP((String)"Create a rule with several conditions");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        ruleModel.setConditions(this.rulesUtils.createVariousConditions());
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        RestRuleModel rule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Retrieve the created rule via the GET endpoint");
        RestRuleModel getRuleBody = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().getSingleRule(rule.getId());
        Step.STEP((String)"Assert that conditions are retrieved using the GET endpoint");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleModel)((RestRuleModel)((RestRuleModel)((RestRuleModel)((RestRuleModel)getRuleBody.assertThat().field(CONDITIONS).contains("comparator=ends")).assertThat().field(CONDITIONS).contains("field=cm:creator")).assertThat().field(CONDITIONS).contains("parameter=ski")).assertThat().field(CONDITIONS).contains("comparator=begins")).assertThat().field(CONDITIONS).contains("field=cm:modelVersion")).assertThat().field(CONDITIONS).contains("parameter=1.");
    }
}

