/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestItemModelsCollection;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessItemsFullTests
extends RestTest {
    private FileModel document1;
    private FileModel document2;
    private FileModel document3;
    private SiteModel siteModel;
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private RestProcessModel processModel;
    private RestItemModelsCollection items;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsTask)).createPublicRandomSite();
        this.document1 = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.document2 = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.document3 = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
    }

    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process items for process without items")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessItemsForProcessWithoutItems() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.items = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.items.assertThat().entriesListIsEmpty();
    }

    @Bug(id="REPO-1989")
    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process items for process with valid skipCount parameter")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessItemsWithValidSkipCount() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document1);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document3);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.items = this.restClient.authenticateUser(this.assignee).withParams(new String[]{"skipCount=2"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.items.assertThat().entriesListContains("name", this.document3.getName())).assertThat().entriesListDoesNotContain("name", this.document1.getName())).assertThat().entriesListDoesNotContain("name", this.document2.getName())).assertThat().entriesListCountIs(1)).assertThat().paginationField("skipCount").is("2");
    }

    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process items for process with negative skipCount")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessItemsWithNegativeSkipCount() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.authenticateUser(this.assignee).withParams(new String[]{"skipCount=-2"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).containsErrorKey(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).statusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process items for process with non numeric skipCount")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessItemsWithNonNumericSkipCount() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.authenticateUser(this.assignee).withParams(new String[]{"skipCount=A"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "A"));
    }

    @Bug(id="MNT-17438")
    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process items for process with valid maxItems parameter")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessItemsWithValidMaxItems() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document1);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document3);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.items = this.restClient.authenticateUser(this.assignee).withParams(new String[]{"maxItems=2"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.items.assertThat().entriesListDoesNotContain("name", this.document3.getName())).assertThat().entriesListContains("name", this.document1.getName())).assertThat().entriesListContains("name", this.document2.getName())).assertThat().entriesListCountIs(2)).assertThat().paginationField("maxItems").is("2");
    }

    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process items for process with negative maxItems")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessItemsWithNegativeMaxItems() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.authenticateUser(this.assignee).withParams(new String[]{"maxItems=-2"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).statusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process items for process with non numeric maxItems")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessItemsWithNonNumericMaxItems() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.authenticateUser(this.assignee).withParams(new String[]{"maxItems=A"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "A"));
    }

    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify get all process items with properties parameter.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessItemsWithPropertiesParameter() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document1);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.items = this.restClient.authenticateUser(this.assignee).withParams(new String[]{"properties=createdBy,name,mimeType,size"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.items.assertThat().entriesListIsNotEmpty();
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.items.getProcessItemByName(this.document1.getName()).assertThat().field("createdBy").is((Object)this.userWhoStartsTask.getUsername())).assertThat().field("name").is((Object)this.document1.getName())).assertThat().field("mimeType").is((Object)this.document1.getFileType().mimeType)).assertThat().field("size").isNotNull()).assertThat().field("modifiedAt").isNull()).assertThat().field("modifiedBy").isNull()).assertThat().field("id").isNull()).assertThat().field("createdAt ").isNull()).assertThat().fieldsCount().is((Object)4);
    }

    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify get all process items after process is deleted.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessItemsAfterDeletingProcess() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document1);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.items = this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.items.assertThat().entriesListIsNotEmpty();
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.items.getProcessItemByName(this.document1.getName()).assertThat().field("createdBy").is((Object)this.userWhoStartsTask.getUsername())).assertThat().field("name").is((Object)this.document1.getName())).assertThat().field("mimeType").is((Object)this.document1.getFileType().mimeType)).assertThat().field("size").isNotNull()).assertThat().field("modifiedAt").isNotNull()).assertThat().field("modifiedBy").is((Object)this.userWhoStartsTask.getUsername())).assertThat().field("id").is((Object)this.document1.getNodeRefWithoutVersion())).assertThat().field("createdAt ").isNotNull();
    }
}

