/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.trashcan;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.RestNodeModelsCollection;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.rest.model.RestRenditionInfoModel;
import org.alfresco.rest.model.RestRenditionInfoModelCollection;
import org.alfresco.rest.requests.Trashcan;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetDeletedNodesTests
extends RestTest {
    private UserModel adminUserModel;
    private SiteModel deleteNodesSiteModel;
    private FolderModel deleteNodesFolder1;
    private FolderModel deleteNodesFolder2;
    private FolderModel deleteNodesFolder3;
    private FolderModel deleteNodesFolder4;
    private FolderModel deleteNodesFolder5;
    private FolderModel getDeleteNodesFolder6;
    private FileModel file;
    private FileModel file1;
    private FileModel file2;
    private FileModel file3;
    private FileModel file4;
    private RestNodeModelsCollection deletedNodes;
    private RestNodeModelsCollection deletedNodesMaxItem;
    private RestNodeModel node;
    private RestRenditionInfoModelCollection nodeRenditionInfoCollection;
    private RestRenditionInfoModel nodeRenditionInfo;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(this.adminUserModel);
        this.deleteNodesSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.deleteNodesSiteModel);
    }

    @Test(groups={"rest-api", "regression"})
    public void testDeletedNodesBiggerThanMaxCount() throws Exception {
        this.deletedNodes = this.restClient.withCoreAPI().usingTrashcan().findDeletedNodes();
        int count = this.deletedNodes.getPagination().getCount();
        int totalItems = this.deletedNodes.getPagination().getTotalItems();
        this.deleteNodesFolder1 = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.deleteNodesSiteModel)).createFolder();
        this.deleteNodesFolder2 = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.deleteNodesSiteModel)).createFolder();
        this.deleteNodesFolder3 = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.deleteNodesSiteModel)).createFolder();
        ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingResource((ContentModel)this.deleteNodesFolder1)).deleteContent();
        ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingResource((ContentModel)this.deleteNodesFolder2)).deleteContent();
        ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingResource((ContentModel)this.deleteNodesFolder3)).deleteContent();
        int maxItems = count + 1;
        this.deletedNodesMaxItem = ((Trashcan)this.restClient.withCoreAPI().usingTrashcan().usingParams(new String[]{String.format("maxItems=%s", maxItems)})).findDeletedNodes();
        String countMaxItem = Integer.toString(maxItems);
        String totalItemsMaxItem = Integer.toString(totalItems + 3);
        String hasMoreItemsMaxItem = Boolean.toString(this.deletedNodesMaxItem.getPagination().isHasMoreItems());
        String skipCount = Integer.toString(this.deletedNodesMaxItem.getPagination().getSkipCount());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)this.deletedNodesMaxItem.getPagination().assertThat().field("totalItems").is((Object)totalItemsMaxItem)).and().field("count").is((Object)countMaxItem);
        ((RestPaginationModel)this.deletedNodesMaxItem.getPagination().assertThat().field("hasMoreItems").is((Object)hasMoreItemsMaxItem)).and().field("skipCount").is((Object)skipCount);
    }

    @TestRail(section={"rest-api", "trashcan"}, executionType={ExecutionType.SANITY}, description="Sanity tests for GET /deleted-nodes and GET /deleted-nodes/{nodeId}")
    @Test(groups={"rest-api", "trashcan", "sanity"})
    public void testGetDeletedNodesFromTrashcan() throws Exception {
        this.deleteNodesFolder4 = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.deleteNodesSiteModel)).createFolder();
        this.file = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.deleteNodesSiteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingResource((ContentModel)this.deleteNodesFolder4)).deleteContent();
        ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingResource((ContentModel)this.file)).deleteContent();
        this.deletedNodes = this.restClient.withCoreAPI().usingTrashcan().findDeletedNodes();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestNodeModel)((RestNodeModel)this.deletedNodes.getEntryByIndex(0)).assertThat().field("name").is((Object)this.file.getName())).and().field("id").is((Object)this.file.getNodeRefWithoutVersion());
        ((RestNodeModel)((RestNodeModel)this.deletedNodes.getEntryByIndex(1)).assertThat().field("name").is((Object)this.deleteNodesFolder4.getName())).and().field("id").is((Object)this.deleteNodesFolder4.getNodeRefWithoutVersion());
        this.node = this.restClient.withCoreAPI().usingTrashcan().findDeletedNode((RepoTestModel)this.deleteNodesFolder4);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestNodeModel)this.node.assertThat().field("name").is((Object)this.deleteNodesFolder4.getName())).and().field("id").is((Object)this.deleteNodesFolder4.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "trashcan"}, executionType={ExecutionType.SANITY}, description="Sanity tests for DELETE /deleted-nodes/{nodeId} and POST /deleted-nodes/{nodeId}/restore")
    @Test(groups={"rest-api", "trashcan", "sanity"})
    public void testDeleteAndRestoreNodeFromTrashcan() throws Exception {
        this.deleteNodesFolder5 = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.deleteNodesSiteModel)).createFolder();
        String docLibNodeRef = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.deleteNodesSiteModel)).getNodeRef();
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.deleteNodesSiteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingResource((ContentModel)this.deleteNodesFolder5)).deleteContent();
        ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingResource((ContentModel)this.file1)).deleteContent();
        this.restClient.withCoreAPI().usingTrashcan().deleteNodeFromTrashcan((RepoTestModel)this.file1);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingTrashcan().findDeletedNode((RepoTestModel)this.file1);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.node = this.restClient.withCoreAPI().usingTrashcan().restoreNodeFromTrashcan((RepoTestModel)this.deleteNodesFolder5);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestNodeModel)this.node.assertThat().field("id").is((Object)this.deleteNodesFolder5.getNodeRefWithoutVersion())).and().field("parentId").is((Object)docLibNodeRef);
        this.restClient.withCoreAPI().usingTrashcan().findDeletedNode((RepoTestModel)this.deleteNodesFolder5);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @TestRail(section={"rest-api", "trashcan"}, executionType={ExecutionType.SANITY}, description="Sanity tests for GET /deleted-nodes/{nodeId}/content")
    @Test(groups={"rest-api", "trashcan", "sanity"})
    public void testGetDeletedNodesContent() throws Exception {
        FileModel newFile = FileModel.getFileModelBasedOnTestDataFile((String)"sampleContent.txt");
        newFile.setName("sampleContent.txt");
        this.file2 = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.deleteNodesSiteModel)).createContent(newFile);
        ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingResource((ContentModel)this.file2)).deleteContent();
        this.restClient.withCoreAPI().usingTrashcan().getDeletedNodeContent((RepoTestModel)this.file2);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.assertHeaderValueContains("Content-Disposition", this.file2.getName());
        this.restClient.onResponse().getResponse().body().asString().contains("Sample text.");
    }

    @Bug(id="REPO-4484")
    @TestRail(section={"rest-api", "trashcan", "require-solr"}, executionType={ExecutionType.SANITY}, description="Sanity tests for GET /deleted-nodes/{nodeId}/renditions, GET /deleted-nodes/{nodeId}/renditions/{renditionId}, GET /deleted-nodes/{nodeId}/renditions/{renditionId}/content")
    @Test(groups={"rest-api", "trashcan", "sanity", "renditions"})
    public void testGetDeletedNodesRenditions() throws Exception {
        this.file3 = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.deleteNodesSiteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file3).createNodeRendition("pdf");
        this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file3).createNodeRendition("doclib");
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingResource((ContentModel)this.file3)).deleteContent();
        Utility.sleep((int)500, (int)60000, () -> {
            this.nodeRenditionInfoCollection = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingTrashcan().getDeletedNodeRenditions((RepoTestModel)this.file3);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            this.nodeRenditionInfoCollection.assertThat().entriesListContains("id", "doclib");
            ((RestRenditionInfoModel)((RestRenditionInfoModel)this.nodeRenditionInfoCollection.getEntryByIndex(5)).assertThat().field("id").is((Object)"pdf")).and().field("status").is((Object)"CREATED");
        });
        this.nodeRenditionInfo = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingTrashcan().getDeletedNodeRendition((RepoTestModel)this.file3, "pdf");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRenditionInfoModel)this.nodeRenditionInfo.assertThat().field("id").is((Object)"pdf")).and().field("status").is((Object)"CREATED");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingTrashcan().getDeletedNodeRenditionContent((RepoTestModel)this.file3, "pdf");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.assertHeaderValueContains("Content-Type", "application/pdf;charset=UTF-8");
        Assert.assertTrue((this.restClient.onResponse().getResponse().body().asInputStream().available() > 0 ? 1 : 0) != 0);
    }

    @Bug(id="REPO-4778")
    @TestRail(section={"rest-api", "trashcan", "require-solr"}, executionType={ExecutionType.SANITY}, description="Sanity test to verify Range request header on GET /deleted-nodes/{nodeId}/renditions/{renditionId}/content endpoint")
    @Test(groups={"rest-api", "trashcan", "sanity", "renditions"})
    public void testGetDeletedNodesRenditionsandVerifyRangeRequestheader() throws Exception {
        this.file4 = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.deleteNodesSiteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file4).createNodeRendition("pdf");
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingResource((ContentModel)this.file4)).deleteContent();
        Utility.sleep((int)500, (int)60000, () -> {
            this.restClient.configureRequestSpec().addHeader("content-range", "bytes=1-10");
            this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingTrashcan().getDeletedNodeRenditionContent((RepoTestModel)this.file4, "pdf");
            this.restClient.assertStatusCodeIs(HttpStatus.PARTIAL_CONTENT);
            this.restClient.assertHeaderValueContains("Content-Type", "application/pdf;charset=UTF-8");
            this.restClient.assertHeaderValueContains("content-range", "bytes 1-10");
            this.restClient.assertHeaderValueContains("content-length", String.valueOf(10));
        });
    }
}

