/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processDefinitions;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessDefinitionImageSanityTests
extends RestTest {
    private UserModel testUser;
    private RestProcessDefinitionModel randomProcessDefinition;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.dataUser.getAdminUser());
        this.randomProcessDefinition = ((RestProcessDefinitionModel)this.restClient.withWorkflowAPI().getAllProcessDefinitions().getOneRandomEntry()).onModel();
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.SANITY}, description="Verify Any user gets a specific process definition image for non-network deployments using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "process-definitions", "sanity", "renditions"})
    public void anyUserGetsProcessDefinitionImage() throws Exception {
        this.restClient.authenticateUser(this.testUser);
        this.restClient.withWorkflowAPI().usingProcessDefinitions(this.randomProcessDefinition).getProcessDefinitionImage().assertResponseContainsImage();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.SANITY}, description="Verify Admin user gets a specific process definition image for non-network deployments using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "process-definitions", "sanity", "renditions"})
    public void adminGetsProcessDefinitionImage() throws Exception {
        this.restClient.withWorkflowAPI().usingProcessDefinitions(this.randomProcessDefinition).getProcessDefinitionImage().assertResponseContainsImage();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }
}

