/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.favorites;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteFavoriteSiteTests
extends RestTest {
    private UserModel userModel;
    private UserModel adminUserModel;
    private SiteModel siteModel1;
    private SiteModel siteModel2;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel1 = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.siteModel2 = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.adminUserModel = this.dataUser.getAdminUser();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel1, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify manager user removes a site from its favorite sites list with Rest API and response is successful (204)")
    public void managerUserRemovesFavoriteSiteWithSuccess() throws Exception {
        UserModel managerUser = this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel2)).addSiteToFavorites();
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().removeFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.restClient.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListDoesNotContain("targetGuid", this.siteModel1.getGuid())).and().entriesListDoesNotContain("id", this.siteModel1.getId())).and().entriesListDoesNotContain("description", this.siteModel1.getDescription())).and().entriesListDoesNotContain("visibility", this.siteModel1.getVisibility().toString())).and().entriesListDoesNotContain("title", this.siteModel1.getTitle());
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify manager user is NOT Authorized to remove a site from its favorite sites list with Rest API when authentication fails (401)")
    public void managerUserNotAuthorizedFailsToRemoveFavoriteSite() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.siteModel1, UserRole.SiteManager);
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel2)).addSiteToFavorites();
        managerUser.setPassword("newpassword");
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().removeFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator user removes a site from its favorite sites list with Rest API and response is successful (204)")
    public void collaboratorUserRemovesFavoriteSiteWithSuccess() throws Exception {
        UserModel collaboratorUser = this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator);
        ((DataSite)((DataSite)this.dataSite.usingUser(collaboratorUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(collaboratorUser)).usingSite(this.siteModel2)).addSiteToFavorites();
        this.restClient.authenticateUser(collaboratorUser).withCoreAPI().usingAuthUser().removeFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.restClient.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListDoesNotContain("targetGuid", this.siteModel1.getGuid())).and().entriesListDoesNotContain("id", this.siteModel1.getId())).and().entriesListDoesNotContain("description", this.siteModel1.getDescription())).and().entriesListDoesNotContain("visibility", this.siteModel1.getVisibility().toString())).and().entriesListDoesNotContain("title", this.siteModel1.getTitle());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor user removes a site from its favorite sites list with Rest API and response is successful (204)")
    public void contributorUserRemovesFavoriteSiteWithSuccess() throws Exception {
        UserModel contributorUser = this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor);
        ((DataSite)((DataSite)this.dataSite.usingUser(contributorUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(contributorUser)).usingSite(this.siteModel2)).addSiteToFavorites();
        this.restClient.authenticateUser(contributorUser).withCoreAPI().usingAuthUser().removeFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.restClient.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListDoesNotContain("targetGuid", this.siteModel1.getGuid())).and().entriesListDoesNotContain("id", this.siteModel1.getId())).and().entriesListDoesNotContain("description", this.siteModel1.getDescription())).and().entriesListDoesNotContain("visibility", this.siteModel1.getVisibility().toString())).and().entriesListDoesNotContain("title", this.siteModel1.getTitle());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer user removes a site from its favorite sites list with Rest API and response is successful (204)")
    public void consumerUserRemovesFavoriteSiteWithSuccess() throws Exception {
        UserModel consumerUser = this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer);
        ((DataSite)((DataSite)this.dataSite.usingUser(consumerUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(consumerUser)).usingSite(this.siteModel2)).addSiteToFavorites();
        this.restClient.authenticateUser(consumerUser).withCoreAPI().usingAuthUser().removeFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.restClient.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListDoesNotContain("targetGuid", this.siteModel1.getGuid())).and().entriesListDoesNotContain("id", this.siteModel1.getId())).and().entriesListDoesNotContain("description", this.siteModel1.getDescription())).and().entriesListDoesNotContain("visibility", this.siteModel1.getVisibility().toString())).and().entriesListDoesNotContain("title", this.siteModel1.getTitle());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user removes a site from any user's favorite sites list with Rest API and response is successful (204)")
    public void adminUserRemovesAnyFavoriteSiteWithSuccess() throws Exception {
        UserModel anyUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataSite)((DataSite)this.dataSite.usingUser(anyUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(anyUser)).usingSite(this.siteModel2)).addSiteToFavorites();
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingUser(anyUser).removeFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify a user removes a site from another user's favorite sites list with Rest API and response is permission denied (403)")
    public void userCannotRemoveAnotherUserFavoriteSite() throws Exception {
        UserModel userAuth = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        UserModel anotherUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataSite)((DataSite)this.dataSite.usingUser(anotherUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(anotherUser)).usingSite(this.siteModel2)).addSiteToFavorites();
        this.restClient.authenticateUser(userAuth).withCoreAPI().usingUser(anotherUser).removeFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify uninvited user can delete favorite public site and response is 204")
    public void uninvitedUserCanDeleteFavoritePublicSite() throws Exception {
        SiteModel publicSiteModel = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.userModel).addFavoriteSite(publicSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().removeFavoriteSite(publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingAuthUser().getFavoriteSites().assertThat().entriesListDoesNotContain("id", publicSiteModel.getId());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify uninvited user can delete favorite moderated site and response is 204")
    public void uninvitedUserCanDeleteFavoriteModeratedSite() throws Exception {
        SiteModel moderatedSiteModel = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.userModel).addFavoriteSite(moderatedSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().removeFavoriteSite(moderatedSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingAuthUser().getFavoriteSites().assertThat().entriesListDoesNotContain("id", moderatedSiteModel.getId());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user can delete favorite private site and response is 204")
    public void userCanDeleteFavoritePrivateSite() throws Exception {
        SiteModel privateSiteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPrivateRandomSite();
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.userModel).addFavoriteSite(privateSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().removeFavoriteSite(privateSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingAuthUser().getFavoriteSites().assertThat().entriesListDoesNotContain("id", privateSiteModel.getId());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify manager user removes a site from its favorites and adds it again and response is successful (204)")
    public void managerUserRemovesFavoriteSiteAndAddItAgain() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.siteModel1, UserRole.SiteManager);
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().removeFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingUser(managerUser).addFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user removes a site from favorites using '-me-' in place of personId with Rest API and response is successful (204)")
    public void removeFavoriteSiteWithSuccessUsingMeAsPersonId() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        ((DataSite)((DataSite)this.dataSite.usingUser(this.adminUserModel)).usingSite(this.siteModel1)).addSiteToFavorites();
        this.restClient.withCoreAPI().usingMe().removeFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify inexistent user is not able to remove a site from favorites and response is 404")
    public void inexistentUserIsNotAbleToRemoveFavoriteSite() throws Exception {
        UserModel inexistentUser = new UserModel("inexistenUser", "password");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(inexistentUser).removeFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "inexistenUser"));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove from favorites a site with inexistent id and response is 404")
    public void userIsNotAbleToRemoveFavoriteSiteWithInexistentId() throws Exception {
        SiteModel inexistentSite = new SiteModel("inexistentSite");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).removeFavoriteSite(inexistentSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.adminUserModel.getUsername(), inexistentSite.getTitle())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="User is not able to remove a favorite site of admin user")
    public void userIsNotAbleToDeleteFavoritesOfAdmin() throws Exception {
        UserModel contributor = this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor);
        ((DataSite)((DataSite)this.dataSite.usingUser(this.adminUserModel)).usingSite(this.siteModel1)).addSiteToFavorites();
        this.restClient.authenticateUser(contributor).withCoreAPI().usingUser(this.adminUserModel).removeFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Users removed twice from favorites same site.")
    public void managerUserRemovesDeletedFavoriteSite() throws Exception {
        UserModel managerUser = this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel1)).addSiteToFavorites();
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().removeFavoriteSite(this.siteModel1);
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().removeFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.NOT_FAVOURITE_SITE, this.siteModel1.getTitle()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Users removes from favorite a site that is already deleted.")
    public void consumerUserRemovesDeletedFavoriteSite() throws Exception {
        SiteModel siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        UserModel consumerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(consumerUser, siteModel, UserRole.SiteConsumer);
        ((DataSite)((DataSite)this.dataSite.usingUser(consumerUser)).usingSite(siteModel)).addSiteToFavorites();
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(siteModel);
        this.restClient.authenticateUser(consumerUser).withCoreAPI().usingAuthUser().removeFavoriteSite(siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, consumerUser.getUsername(), siteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Delete  favorite site that is NOT favorite.")
    public void adminUserRemovesDeletedFavoriteSiteThatIsNotFavorite() throws Exception {
        SiteModel siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().removeFavoriteSite(siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.NOT_FAVOURITE_SITE, siteModel.getTitle()));
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user doesn't have permission to delete favorites of another user with Rest API and status code is 403")
    @Test(groups={"rest-api", "people", "regression"})
    public void siteMemberIsNotAbleToDeleteFavoritesOfAnotherSiteMember() throws Exception {
        UserModel siteCollaborator = this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator);
        ((DataSite)((DataSite)this.dataSite.usingUser(siteCollaborator)).usingSite(this.siteModel1)).addSiteToFavorites();
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingUser(siteCollaborator).removeFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }
}

