/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests.cmisAPI;

import io.restassured.RestAssured;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.utility.model.ContentModel;
import org.springframework.http.HttpMethod;

public class RestCmisAPI
extends ModelRequest<RestCmisAPI> {
    public RestCmisAPI(RestWrapper restWrapper) {
        super(restWrapper);
        RestAssured.basePath = "alfresco/api/-default-/public/cmis/versions/1.1/browser";
        restWrapper.configureRequestSpec().setBasePath(RestAssured.basePath);
    }

    public RestResponse getRootObjectByLocation(ContentModel contentModel) {
        return this.getRootObjectByLocation(contentModel.getName());
    }

    public RestResponse getRootObjectByLocation(String objectName) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "root/Shared/{objectName}?{parameters}", objectName, this.restWrapper.getParameters());
        return this.restWrapper.process(request);
    }

    public RestResponse getRootObjectByID(ContentModel contentModel) {
        return this.getRootObjectByID(contentModel.getNodeRef());
    }

    public RestResponse getRootObjectByID(String objectID) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "root?objectid={objectId}?{parameters}", objectID, this.restWrapper.getParameters());
        return this.restWrapper.process(request);
    }
}

