/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people.preferences;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.constants.PreferenceName;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetPeoplePreferenceCoreTests
extends RestTest {
    UserModel userModel;
    SiteModel siteModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        ((DataSite)((DataSite)this.dataSite.usingUser(this.userModel)).usingSite(this.siteModel)).addSiteToFavorites();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify user is Forbidden to get a specific preference for another user with Rest API and response is 403")
    public void userDoesNotHaveAccessToFavoriteSitesOfAnotherUser() throws Exception {
        UserModel secondUser = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(secondUser).withCoreAPI().usingUser(this.userModel).getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.assertLastError().containsSummary("Permission was denied");
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify manager fails to get a specific preference for an invalid user with Rest API and response is 404")
    public void statusNotFoundIsReturnedForAPersonIDThatDoesNotExist() throws Exception {
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(new UserModel("invalidPersonID", "password")).getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidPersonID")).statusCodeIs(HttpStatus.NOT_FOUND).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify manager fails to get a specific preference for an invalid preference with Rest API and response is 404")
    public void statusNotFoundIsReturnedForAPreferenceNameThatDoesNotExist() throws Exception {
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingAuthUser().getPersonPreferenceInformation("invalidPreferenceName");
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.restClient.assertLastError().containsSummary(String.format("The relationship resource was not found for the entity with id: %s and a relationship id of invalidPreferenceName", this.userModel.getUsername()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify manager fails to get a specific preference for  removed preference with Rest API and response is 404")
    public void statusNotFoundIsReturnedForAPreferenceNameThatHasBeenRemoved() throws Exception {
        SiteModel preferenceSite = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        ((DataSite)((DataSite)this.dataSite.usingUser(this.userModel)).usingSite(preferenceSite)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(this.userModel)).usingSite(preferenceSite)).removeSiteFromFavorites();
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), preferenceSite.getId()));
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.restClient.assertLastError().containsSummary(String.format("The relationship resource was not found for the entity with id: %s and a relationship id of %s", this.userModel.getUsername(), String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), preferenceSite.getId())));
    }
}

