/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people.deauthorization.community;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestAuthKeyModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class ReauthorizeSanityTests
extends RestTest {
    private UserModel userModel;
    private UserModel adminUser;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Check if reauthorization is not implemented in Community Edition")
    public void reauthorizationIsNotImplementedInCommunityEdition() {
        RestAuthKeyModel key = new RestAuthKeyModel();
        key.setAuthorizationKey("am9obnRlc3RAMTIzNDU=");
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(this.userModel).reauthorizeUser(key);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_IMPLEMENTED);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.userModel).reauthorizeUser(key);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_IMPLEMENTED);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Check if the reauthorization code is not implemented in Community Edition")
    public void reauthorizationCodeIsNotImplementedInCommunityEdition() {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(this.userModel).getReauthorizationCode();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_IMPLEMENTED);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.userModel).getReauthorizationCode();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_IMPLEMENTED);
    }
}

