/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.nodes;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestActionDefinitionModelsCollection;
import org.alfresco.rest.model.builder.NodesBuilder;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NodesActionDefinitionTests
extends RestTest {
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify actions")
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void testActionDefinition() throws Exception {
        this.restClient.authenticateUser(this.dataContent.getAdminUser());
        NodesBuilder nodesBuilder = this.restClient.withCoreAPI().usingNode((RepoTestModel)ContentModel.my()).defineNodes();
        NodesBuilder.NodeDetail sourceFolder = nodesBuilder.folder("sourceFolder");
        NodesBuilder.NodeDetail file = sourceFolder.file("file");
        ContentModel fileActionDefinitions = new ContentModel();
        fileActionDefinitions.setNodeRef(file.getId());
        RestActionDefinitionModelsCollection restActionDefinitions = this.restClient.withCoreAPI().usingNode((RepoTestModel)fileActionDefinitions).getActionDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertFalse((boolean)restActionDefinitions.isEmpty());
        restActionDefinitions.assertThat().entriesListContains("name", "copy");
        restActionDefinitions.assertThat().entriesListContains("name", "move");
        restActionDefinitions.assertThat().entriesListContains("name", "check-out");
        restActionDefinitions.assertThat().entriesListContains("name", "check-in");
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify actions negative request")
    @Test(groups={"rest-api", "nodes", "regression"})
    public void testActionDefinitionNegative() throws Exception {
        NodesBuilder nodesBuilder = this.restClient.withCoreAPI().usingNode((RepoTestModel)ContentModel.my()).defineNodes();
        NodesBuilder.NodeDetail sourceFolder = nodesBuilder.folder("sourceFolder");
        ContentModel validNode = new ContentModel();
        validNode.setNodeRef(sourceFolder.getId());
        ContentModel fakeNode = new ContentModel();
        fakeNode.setNodeRef("750a2867-ecfa-478c-8343-fa0e39d27be3");
        this.restClient.authenticateUser(this.dataContent.getAdminUser()).withCoreAPI().usingNode((RepoTestModel)fakeNode).getActionDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.restClient.authenticateUser(this.dataContent.getAdminUser()).withParams(new String[]{"skipCount=-1"}).withCoreAPI().usingNode((RepoTestModel)validNode).getActionDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        UserModel userUnauthorized = new UserModel("invalid-user", "invalid-pasword");
        this.restClient.authenticateUser(userUnauthorized).withCoreAPI().usingNode((RepoTestModel)validNode).getActionDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }
}

