/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.models.types;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestAbstractClassModel;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.rest.model.RestTypesCollection;
import org.alfresco.rest.requests.modelAPI.RestModelAPI;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetTypesTests
extends RestTest {
    private UserModel regularUser;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.regularUser = this.dataUser.createRandomTestUser();
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Verify user get types and gets status code OK (200)")
    public void getTypes() throws Exception {
        RestTypesCollection types = this.restClient.authenticateUser(this.regularUser).withModelAPI().getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)types.assertThat().entriesListCountIs(100)).and().entriesListContains("id", "cm:content")).and().entriesListContains("id", "cm:systemfolder")).and().entriesListContains("id", "cm:folder");
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Should filter types using namespace uri and gets status code OK (200)")
    public void getTypeByNamespaceUri() throws Exception {
        RestTypesCollection types = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(namespaceUri matches('http://www.alfresco.org/model.*'))"})).getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        types.assertThat().entriesListCountIs(100);
        types = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(not namespaceUri matches('http://www.alfresco.org/model.*'))"})).getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        types.assertThat().entriesListCountIs(0);
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Should filter types using modelId and gets status code OK (200)")
    public void getTypeByModelsIds() throws Exception {
        RestTypesCollection types = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(modelId in ('cm:contentmodel', 'smf:smartFolder'))"})).getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)types.getPagination().assertThat().fieldsCount().is((Object)5)).and().field("totalItems").isLessThan(Integer.valueOf(65))).and().field("maxItems").is((Object)100)).and().field("skipCount").isGreaterThan(Integer.valueOf(0))).and().field("hasMoreItems").is((Object)false);
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Should filter types using modelId with subtypes and gets status code OK (200)")
    public void getTypeByModelsIdsWithIncludeSubTypes() throws Exception {
        RestTypesCollection types = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(modelId in ('cm:contentmodel INCLUDESUBTYPES', 'smf:smartFolder INCLUDESUBTYPES'))"})).getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)types.getPagination().assertThat().fieldsCount().is((Object)5)).and().field("totalItems").isGreaterThan(Integer.valueOf(65))).and().field("maxItems").is((Object)100)).and().field("skipCount").isGreaterThan(Integer.valueOf(0))).and().field("hasMoreItems").is((Object)false);
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Should filter types using parentId and gets status code OK (200)")
    public void getTypeByParentId() throws Exception {
        RestTypesCollection types = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(parentId in ('cm:content'))"})).getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)types.getPagination().assertThat().fieldsCount().is((Object)5)).and().field("totalItems").isGreaterThan(Integer.valueOf(40))).and().field("hasMoreItems").is((Object)false);
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Should get Type with association, properties and mandatory types and gets status code OK (200)")
    public void getTypeIncludeParams() throws Exception {
        RestTypesCollection types = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"include=properties,mandatoryAspects,associations"})).getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        for (RestAbstractClassModel type : types.getEntries()) {
            ((RestAbstractClassModel)((RestAbstractClassModel)type.onModel().assertThat().field("associations").isNotNull()).and().field("properties").isNotNull()).and().field("mandatoryAspects").isNotNull();
        }
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Should verify the query errors with possible options")
    public void verifyTypesQueryError() throws Exception {
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(modelId in (' ')"})).getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(modelId in ('cm:contentmodel INCLUDESUBTYPES',))"})).getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(modelId in ('cm:contentmodel INCLUDESUBASPECTS'))"})).getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(parentId in (' ')"})).getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(parentId in ('cm:titled',))"})).getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(parentId in ('cm:titled',))&include=properties"})).getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(namespaceUri matches('*'))"})).getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(parentId in ('cm:titled'))&include=properties"})).getTypes();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets types with high skipCount and maxItems parameter applied")
    public void getPaginationParameter() throws Exception {
        RestTypesCollection types = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"maxItems=10&skipCount=10"})).getTypes();
        types.assertThat().entriesListCountIs(10);
        types.assertThat().paginationField("hasMoreItems").is("true");
        types.assertThat().paginationField("skipCount").is("10");
        types.assertThat().paginationField("maxItems").is("10");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets types with hasMoreItems applied bases on skip count and maxItems")
    public void getHighPaginationQuery() throws Exception {
        RestTypesCollection types = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"maxItems=10&skipCount=150"})).getTypes();
        types.assertThat().entriesListCountIs(0);
        types.assertThat().paginationField("hasMoreItems").is("false");
        types.assertThat().paginationField("skipCount").is("150");
        types.assertThat().paginationField("maxItems").is("10");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }
}

