/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.categories;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.rest.categories.CategoriesRestTest;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.model.RestCategoryModelsCollection;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.rest.requests.Categories;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class CreateCategoriesTests
extends CategoriesRestTest {
    @Test(groups={"rest-api"})
    public void testCreateCategoryUnderRoot() {
        Step.STEP((String)"Create a category under root category (as admin)");
        RestCategoryModel rootCategory = this.createCategoryModelWithId("-root-");
        RestCategoryModel aCategory = this.createCategoryModelWithName(RandomData.getRandomName((String)"Category"));
        RestCategoryModel createdCategory = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(rootCategory).createSingleCategory(aCategory);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        createdCategory.assertThat().field("name").is((Object)aCategory.getName());
        createdCategory.assertThat().field("parentId").is((Object)rootCategory.getId());
        createdCategory.assertThat().field("hasChildren").is((Object)false);
    }

    @Test(groups={"rest-api"})
    public void testCreateCategoryWithoutName_andFail() {
        Step.STEP((String)"Create a category under root category (as admin)");
        RestCategoryModel rootCategory = this.createCategoryModelWithId("-root-");
        RestCategoryModel aCategory = this.createCategoryModelWithName("");
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(rootCategory).createSingleCategory(aCategory);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Category name must not be null or empty");
    }

    @Test(groups={"rest-api"})
    public void testCreateSeveralSubCategories() {
        Step.STEP((String)"Create a category under root category (as admin)");
        RestCategoryModel rootCategory = this.createCategoryModelWithId("-root-");
        RestCategoryModel aCategory = this.createCategoryModelWithName(RandomData.getRandomName((String)"Category"));
        RestCategoryModel createdCategory = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(rootCategory).createSingleCategory(aCategory);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestCategoryModel)((RestCategoryModel)((RestCategoryModel)createdCategory.assertThat().field("name").is((Object)aCategory.getName())).assertThat().field("parentId").is((Object)rootCategory.getId())).assertThat().field("hasChildren").is((Object)false)).assertThat().field("id").isNotEmpty();
        Step.STEP((String)"Create two categories under the previously created (as admin)");
        int categoriesNumber = 2;
        List<RestCategoryModel> categoriesToCreate = CreateCategoriesTests.getCategoriesToCreate(2);
        RestCategoryModelsCollection createdSubCategories = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(createdCategory).createCategoriesList(categoriesToCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        createdSubCategories.assertThat().entriesListCountIs(categoriesToCreate.size());
        IntStream.range(0, 2).forEach(i -> ((RestCategoryModel)((RestCategoryModel)((RestCategoryModel)((RestCategoryModel)createdSubCategories.getEntries().get(i)).onModel().assertThat().field("name").is((Object)((RestCategoryModel)categoriesToCreate.get(i)).getName())).assertThat().field("parentId").is((Object)createdCategory.getId())).assertThat().field("hasChildren").is((Object)false)).assertThat().field("id").isNotEmpty());
        Step.STEP((String)"Get the parent category and check if it now has children (as regular user)");
        RestCategoryModel parentCategoryFromGet = this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(createdCategory).getCategory();
        parentCategoryFromGet.assertThat().field("hasChildren").is((Object)true);
    }

    @Test(groups={"rest-api"})
    public void testCreateOver100SubCategories() {
        Step.STEP((String)"Create a category under root category (as admin)");
        RestCategoryModel rootCategory = this.createCategoryModelWithId("-root-");
        RestCategoryModel aCategory = this.createCategoryModelWithName(RandomData.getRandomName((String)"Category"));
        RestCategoryModel createdCategory = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(rootCategory).createSingleCategory(aCategory);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestCategoryModel)((RestCategoryModel)((RestCategoryModel)createdCategory.assertThat().field("name").is((Object)aCategory.getName())).assertThat().field("parentId").is((Object)rootCategory.getId())).assertThat().field("hasChildren").is((Object)false)).assertThat().field("id").isNotEmpty();
        Step.STEP((String)"Create more than a hundred categories under the previously created (as admin)");
        int categoriesNumber = 120;
        List<RestCategoryModel> categoriesToCreate = CreateCategoriesTests.getCategoriesToCreate(120);
        RestCategoryModelsCollection createdSubCategories = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(createdCategory).createCategoriesList(categoriesToCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        createdSubCategories.assertThat().entriesListCountIs(categoriesToCreate.size());
        IntStream.range(0, 120).forEach(i -> ((RestCategoryModel)((RestCategoryModel)((RestCategoryModel)((RestCategoryModel)createdSubCategories.getEntries().get(i)).onModel().assertThat().field("name").is((Object)((RestCategoryModel)categoriesToCreate.get(i)).getName())).assertThat().field("parentId").is((Object)createdCategory.getId())).assertThat().field("hasChildren").is((Object)false)).assertThat().field("id").isNotEmpty());
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)createdSubCategories.getPagination().assertThat().field("count").is((Object)120)).assertThat().field("totalItems").is((Object)120)).assertThat().field("maxItems").is((Object)120)).assertThat().field("skipCount").is((Object)0)).assertThat().field("hasMoreItems").is((Object)false);
    }

    @Test(groups={"rest-api"})
    public void testCreateCategoryUnderRootAsRegularUser_andFail() {
        Step.STEP((String)"Create a category under root category (as user)");
        RestCategoryModel rootCategory = this.createCategoryModelWithId("-root-");
        RestCategoryModel aCategory = this.createCategoryModelWithName(RandomData.getRandomName((String)"Category"));
        this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(rootCategory).createSingleCategory(aCategory);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary("Current user does not have permission to manage a category");
    }

    @Test(groups={"rest-api"})
    public void testCreateCategoryUnderNonExistingParent_andFail() {
        Step.STEP((String)"Create a category under non existing category node (as admin)");
        String id = "non-existing-node-id";
        RestCategoryModel rootCategory = this.createCategoryModelWithId("non-existing-node-id");
        RestCategoryModel aCategory = this.createCategoryModelWithName(RandomData.getRandomName((String)"Category"));
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(rootCategory).createSingleCategory(aCategory);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary("The entity with id: non-existing-node-id was not found");
    }

    @Test(groups={"rest-api"})
    public void testCreateCategoryUnderFolderNode_andFail() {
        Step.STEP((String)"Create a site and a folder inside it");
        SiteModel site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(site)).createFolder();
        Step.STEP((String)"Create a category under folder node (as admin)");
        RestCategoryModel rootCategory = this.createCategoryModelWithId(folder.getNodeRef());
        RestCategoryModel aCategory = this.createCategoryModelWithName(RandomData.getRandomName((String)"Category"));
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(rootCategory).createSingleCategory(aCategory);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Node id does not refer to a valid category");
    }

    @Test(groups={"rest-api"})
    public void testCreateCategoryUnderRoot_verifyIfCountInRequestIsIgnored() {
        Step.STEP((String)"Try to create a category with filled count under root");
        RestCategoryModel rootCategory = this.createCategoryModelWithId("-root-");
        RestCategoryModel aCategory = this.createCategoryModelWithName(RandomData.getRandomName((String)"Category"));
        aCategory.setCount(2L);
        RestCategoryModel createdCategory = ((Categories)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(rootCategory).include(new String[]{"count"})).createSingleCategory(aCategory);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        createdCategory.assertThat().field("name").is((Object)aCategory.getName());
        createdCategory.assertThat().field("count").is((Object)0);
    }

    static List<RestCategoryModel> getCategoriesToCreate(int count) {
        return IntStream.range(0, count).mapToObj(i -> RestCategoryModel.builder().name(RandomData.getRandomName((String)"SubCategory")).create()).collect(Collectors.toList());
    }
}

