/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.favorites;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.dataprep.SiteService;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestPersonFavoritesModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetFavoriteTests
extends RestTest {
    private UserModel adminUserModel;
    private SiteModel siteModel;
    private FolderModel folderModel;
    private FileModel fileModel;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.folderModel = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.siteModel)).createFolder();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingResource((ContentModel)this.folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.SANITY}, description="Verify Manager user gets favorite site with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "sanity"})
    public void managerIsAbleToRetrieveFavoriteSite() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        RestPersonFavoritesModel favSite = this.restClient.withCoreAPI().usingAuthUser().getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favSite.assertThat().field("targetGuid").is((Object)this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.SANITY}, description="Verify Manager user gets favorite folder with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "sanity"})
    public void managerIsAbleToRetrieveFavoriteFolder() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingAuthUser().addFolderToFavorites(this.folderModel);
        RestPersonFavoritesModel favoriteFolder = this.restClient.withCoreAPI().usingAuthUser().getFavorite(this.folderModel.getNodeRef());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteFolder.assertThat().field("targetGuid").is((Object)this.folderModel.getNodeRef());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.SANITY}, description="Verify Manager user gets favorite file with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "sanity"})
    public void managerIsAbleToRetrieveFavoriteFile() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.fileModel);
        RestPersonFavoritesModel favoriteFile = this.restClient.withCoreAPI().usingAuthUser().getFavorite(this.fileModel.getNodeRefWithoutVersion());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteFile.assertThat().field("targetGuid").is((Object)this.fileModel.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.SANITY}, description="Verify user gets status code 401 if authentication call fails")
    @Test(groups={"rest-api", "favorites", "sanity"})
    public void userIsNotAbleToRetrieveFavoriteSiteIfAuthenticationFails() throws Exception {
        UserModel siteManager = this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        siteManager.setPassword("wrongPassword");
        this.restClient.authenticateUser(siteManager).withCoreAPI().usingUser(siteManager).getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets favorite site with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsAbleToRetrieveFavoritesSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).addSiteToFavorites(this.siteModel);
        RestPersonFavoritesModel favoriteSite = this.restClient.withCoreAPI().usingUser(this.adminUserModel).getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteSite.assertThat().field("targetGuid").is((Object)this.siteModel.getGuid());
        favoriteSite.getTarget().getSite().assertThat().field("guid").is((Object)this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets favorite folder with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsAbleToRetrieveFavoritesFolder() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).addFolderToFavorites(this.folderModel);
        RestPersonFavoritesModel favoriteFolder = this.restClient.withCoreAPI().usingUser(this.adminUserModel).getFavorite(this.folderModel.getNodeRef());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteFolder.assertThat().field("targetGuid").is((Object)this.folderModel.getNodeRef());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets favorite file with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsAbleToRetrieveFavoritesFile() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).addFileToFavorites(this.fileModel);
        RestPersonFavoritesModel favoriteFile = this.restClient.withCoreAPI().usingUser(this.adminUserModel).getFavorite(this.fileModel.getNodeRefWithoutVersion());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteFile.assertThat().field("targetGuid").is((Object)this.fileModel.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user gets favorite site with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void collaboratorIsAbleToRetrieveFavoriteSite() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        RestPersonFavoritesModel favSite = this.restClient.withCoreAPI().usingAuthUser().getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favSite.assertThat().field("targetGuid").is((Object)this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator user gets favorite folder with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void collaboratorIsAbleToRetrieveFavoriteFolder() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingAuthUser().addFolderToFavorites(this.folderModel);
        RestPersonFavoritesModel favoriteFolder = this.restClient.withCoreAPI().usingAuthUser().getFavorite(this.folderModel.getNodeRef());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteFolder.assertThat().field("targetGuid").is((Object)this.folderModel.getNodeRef());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator user gets favorite file with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void collaboratorIsAbleToRetrieveFavoriteFile() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.fileModel);
        RestPersonFavoritesModel favoriteFile = this.restClient.withCoreAPI().usingAuthUser().getFavorite(this.fileModel.getNodeRefWithoutVersion());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteFile.assertThat().field("targetGuid").is((Object)this.fileModel.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user gets favorite site with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void contributorIsAbleToRetrieveFavoriteSite() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        RestPersonFavoritesModel favSite = this.restClient.withCoreAPI().usingAuthUser().getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favSite.assertThat().field("targetGuid").is((Object)this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor user gets favorite folder with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void contributorIsAbleToRetrieveFavoriteFolder() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingAuthUser().addFolderToFavorites(this.folderModel);
        RestPersonFavoritesModel favoriteFolder = this.restClient.withCoreAPI().usingAuthUser().getFavorite(this.folderModel.getNodeRef());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteFolder.assertThat().field("targetGuid").is((Object)this.folderModel.getNodeRef());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor user gets favorite file with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void contributorIsAbleToRetrieveFavoriteFile() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.fileModel);
        RestPersonFavoritesModel favoriteFile = this.restClient.withCoreAPI().usingAuthUser().getFavorite(this.fileModel.getNodeRefWithoutVersion());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteFile.assertThat().field("targetGuid").is((Object)this.fileModel.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Consumer user gets favorite site with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void consumerIsAbleToRetrieveFavorites() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        RestPersonFavoritesModel favSite = this.restClient.withCoreAPI().usingAuthUser().getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favSite.assertThat().field("targetGuid").is((Object)this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer user gets favorite folder with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void consumerIsAbleToRetrieveFavoriteFolder() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingAuthUser().addFolderToFavorites(this.folderModel);
        RestPersonFavoritesModel favoriteFolder = this.restClient.withCoreAPI().usingAuthUser().getFavorite(this.folderModel.getNodeRef());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteFolder.assertThat().field("targetGuid").is((Object)this.folderModel.getNodeRef());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer user gets favorite file with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void consumerIsAbleToRetrieveFavoriteFile() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.fileModel);
        RestPersonFavoritesModel favoriteFile = this.restClient.withCoreAPI().usingAuthUser().getFavorite(this.fileModel.getNodeRefWithoutVersion());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteFile.assertThat().field("targetGuid").is((Object)this.fileModel.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify user doesn't get favorite site of another user with Rest API and status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsNotAbleToRetrieveFavoriteSiteOfAnotherSiteMember() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator).getUsername()));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify user doesn't get favorite site of admin user with Rest API and status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsNotAbleToRetrieveFavoritesOfAdminUser() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingUser(this.adminUserModel).getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.adminUserModel.getUsername()));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user doesn't get favorite site of another user with Rest API and status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsNotAbleToRetrieveFavoritesOfAnotherUser() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator).getUsername()));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify get favorite user doesn't have any favorite site, file or folder")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void getFavoriteSiteForUserWithoutAnyFavorites() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingAuthUser().getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager).getUsername(), this.siteModel.getGuid())).statusCodeIs(HttpStatus.NOT_FOUND).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify get favorite site for -me-")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void getFavoriteSiteUsingMe() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        RestPersonFavoritesModel favoriteSite = this.restClient.withCoreAPI().usingMe().getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteSite.assertThat().field("targetGuid").is((Object)this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify get favorite site for -me-")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void getFavoriteFileUsingMe() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingAuthUser().addFileToFavorites(this.fileModel);
        RestPersonFavoritesModel favoriteFile = this.restClient.withCoreAPI().usingMe().getFavorite(this.fileModel.getNodeRefWithoutVersion());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteFile.assertThat().field("targetGuid").is((Object)this.fileModel.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify get favorite site when person id does't exist")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void getFavoriteSiteWhenPersonIdNotExist() throws Exception {
        this.restClient.withCoreAPI().usingUser(this.adminUserModel).addSiteToFavorites(this.siteModel);
        UserModel someUser = new UserModel("invalidUser", DataUser.PASSWORD);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(someUser).getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, someUser.getUsername())).statusCodeIs(HttpStatus.NOT_FOUND).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY);
    }

    @Bug(id="ACE-2413")
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify get favorite site when person id is empty")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void getFavoriteSiteWithEmptyUserId() throws Exception {
        this.restClient.withCoreAPI().usingUser(this.adminUserModel).addSiteToFavorites(this.siteModel);
        UserModel someUser = new UserModel("", DataUser.PASSWORD);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(someUser).getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, someUser.getUsername())).statusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify get favorite site when favorite id does't exist")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void getFavoriteSiteWhenFavoriteIdNotExist() throws Exception {
        this.restClient.withCoreAPI().usingUser(this.adminUserModel).addSiteToFavorites(this.siteModel);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).getFavorite("invalidId");
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidId")).statusCodeIs(HttpStatus.NOT_FOUND).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets favorite site with properties filter")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void verifyRequestForGetFavoriteSiteWithProperties() throws Exception {
        UserModel collaborator = this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(collaborator);
        this.restClient.withCoreAPI().usingUser(collaborator).addSiteToFavorites(this.siteModel);
        RestPersonFavoritesModel favoriteSite = this.restClient.authenticateUser(collaborator).withParams(new String[]{"properties=targetGuid"}).withCoreAPI().usingAuthUser().getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteSite.assertThat().field("targetGuid").is((Object)this.siteModel.getGuid());
        favoriteSite.assertThat().fieldsCount().is((Object)1);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets favorite site with inccorect properties filter")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void verifyRequestForGetFavoriteSiteWithInvalidProperties() throws Exception {
        UserModel collaborator = this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(collaborator);
        this.restClient.withCoreAPI().usingUser(collaborator).addFileToFavorites(this.fileModel);
        RestPersonFavoritesModel favoriteFile = this.restClient.authenticateUser(collaborator).withParams(new String[]{"properties=tas"}).withCoreAPI().usingAuthUser().getFavorite(this.fileModel.getNodeRefWithoutVersion());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        favoriteFile.assertThat().fieldsCount().is((Object)0);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify all values from get favorite rest api for a file")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void verifyRequestFieldsForGetFavoriteFile() throws Exception {
        UserModel contributor = this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor);
        this.restClient.authenticateUser(contributor);
        this.restClient.withCoreAPI().usingUser(contributor).addFileToFavorites(this.fileModel);
        RestPersonFavoritesModel favoriteFile = this.restClient.authenticateUser(contributor).withCoreAPI().usingAuthUser().getFavorite(this.fileModel.getNodeRefWithoutVersion());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)favoriteFile.assertThat().field("targetGuid").is((Object)this.fileModel.getNodeRefWithoutVersion())).and().field("target.file.isFile").is((Object)"true")).and().field("target.file.mimeType").is((Object)"text/plain")).and().field("target.file.isFolder").is((Object)"false")).and().field("target.file.createdBy").is((Object)this.adminUserModel.getUsername())).and().field("target.file.versionLabel").is((Object)"1.0")).and().field("target.file.name").is((Object)this.fileModel.getName())).and().field("target.file.parentId").is((Object)this.folderModel.getNodeRef())).and().field("target.file.guid").is((Object)this.fileModel.getNodeRefWithoutVersion())).and().field("target.file.modifiedBy").is((Object)this.adminUserModel.getUsername())).and().field("target.file.id").is((Object)this.fileModel.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify all values from get favorite rest api for a site")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void verifyRequestFieldsForGetFavoriteSite() throws Exception {
        UserModel contributor = this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor);
        this.restClient.authenticateUser(contributor);
        this.restClient.withCoreAPI().usingUser(contributor).addFavoriteSite(this.siteModel);
        RestPersonFavoritesModel favoriteSite = this.restClient.authenticateUser(contributor).withCoreAPI().usingAuthUser().getFavorite(this.siteModel.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)favoriteSite.assertThat().field("targetGuid").is((Object)this.siteModel.getGuid())).and().field("target.site.role").is((Object)UserRole.SiteContributor.toString())).and().field("target.site.visibility").is((Object)SiteService.Visibility.PUBLIC.toString())).and().field("target.site.guid").is((Object)this.siteModel.getGuid())).and().field("target.site.description").is((Object)this.siteModel.getDescription())).and().field("target.site.id").is((Object)this.siteModel.getId())).and().field("target.site.preset").is((Object)"site-dashboard")).and().field("target.site.title").is((Object)this.siteModel.getTitle());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify all values from get favorite rest api for a folder")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void verifyRequestFieldsForGetFavoriteFolder() throws Exception {
        UserModel contributor = this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor);
        this.restClient.authenticateUser(contributor);
        this.restClient.withCoreAPI().usingUser(contributor).addFolderToFavorites(this.folderModel);
        RestPersonFavoritesModel favoriteFolder = this.restClient.authenticateUser(contributor).withCoreAPI().usingAuthUser().getFavorite(this.folderModel.getNodeRef());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)((RestPersonFavoritesModel)favoriteFolder.assertThat().field("targetGuid").is((Object)this.folderModel.getNodeRef())).and().field("target.folder.isFile").is((Object)"false")).and().field("target.folder.isFolder").is((Object)"true")).and().field("target.folder.createdBy").is((Object)this.adminUserModel.getUsername())).and().field("target.folder.name").is((Object)this.folderModel.getName())).and().field("target.folder.guid").is((Object)this.folderModel.getNodeRef())).and().field("target.folder.modifiedBy").is((Object)this.adminUserModel.getUsername())).and().field("target.folder.id").is((Object)this.folderModel.getNodeRef());
    }
}

