/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.exception.EmptyJsonResponseException;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestActivityModelsCollection;
import org.alfresco.rest.model.RestAuthCodeModel;
import org.alfresco.rest.model.RestAuthKeyModel;
import org.alfresco.rest.model.RestFavoriteSiteModel;
import org.alfresco.rest.model.RestGroupsModelsCollection;
import org.alfresco.rest.model.RestNetworkModel;
import org.alfresco.rest.model.RestNetworkModelsCollection;
import org.alfresco.rest.model.RestPersonFavoritesModel;
import org.alfresco.rest.model.RestPersonFavoritesModelsCollection;
import org.alfresco.rest.model.RestPersonModel;
import org.alfresco.rest.model.RestPreferenceModel;
import org.alfresco.rest.model.RestPreferenceModelsCollection;
import org.alfresco.rest.model.RestSiteEntry;
import org.alfresco.rest.model.RestSiteMembershipModelsCollection;
import org.alfresco.rest.model.RestSiteMembershipRequestModel;
import org.alfresco.rest.model.RestSiteMembershipRequestModelsCollection;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.rest.model.RestSiteModelsCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class People
extends ModelRequest<People> {
    UserModel person;

    public People(UserModel person, RestWrapper restWrapper) {
        super(restWrapper);
        this.person = person;
        Utility.checkObjectIsInitialized((Object)this.person, (String)"person");
    }

    public RestPersonModel getPerson() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}?{parameters}", this.person.getUsername(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestPersonModel.class, request);
    }

    public RestPersonModel updatePerson(String putBody) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, putBody, "people/{personId}", this.person.getUsername());
        return this.restWrapper.processModel(RestPersonModel.class, request);
    }

    public RestActivityModelsCollection getPersonActivitiesUntilEntriesCountIs(int expectedNoOfEntries) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/activities?{parameters}", this.person.getUsername(), this.restWrapper.getParameters());
        RestActivityModelsCollection activityCollection = this.restWrapper.processModels(RestActivityModelsCollection.class, request);
        if (Integer.valueOf(this.restWrapper.getStatusCode()).equals(HttpStatus.OK.value())) {
            for (int retry = 0; (activityCollection.isEmpty() || activityCollection.getPagination().getCount() != expectedNoOfEntries) && retry < Utility.retryCountSeconds + 20; ++retry) {
                Utility.waitToLoopTime((int)2, (String[])new String[0]);
                activityCollection = this.restWrapper.processModels(RestActivityModelsCollection.class, request);
            }
        }
        return activityCollection;
    }

    public RestActivityModelsCollection getPersonActivities() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/activities?{parameters}", this.person.getUsername(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestActivityModelsCollection.class, request);
    }

    public RestPreferenceModelsCollection getPersonPreferences() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/preferences?{parameters}", this.person.getUsername(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestPreferenceModelsCollection.class, request);
    }

    public RestSiteMembershipRequestModelsCollection getSiteMembershipRequests() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/site-membership-requests?{parameters}", this.person.getUsername(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestSiteMembershipRequestModelsCollection.class, request);
    }

    public RestSiteModelsCollection getFavoriteSites() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/favorite-sites?{parameters}", this.person.getUsername(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestSiteModelsCollection.class, request);
    }

    public RestFavoriteSiteModel addFavoriteSite(SiteModel site) {
        String postBody = JsonBodyGenerator.keyValueJson("id", site.getId());
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "people/{personId}/favorite-sites", this.person.getUsername());
        return this.restWrapper.processModel(RestFavoriteSiteModel.class, request);
    }

    public RestPreferenceModel getPersonPreferenceInformation(String preferenceName) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/preferences/{preferenceName}?{parameters}", this.person.getUsername(), preferenceName, this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestPreferenceModel.class, request);
    }

    public RestPreferenceModel updatePersonPreferenceInformation(String preferenceName, RestPreferenceModel preferenceModel) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, preferenceModel.toJson(), "people/{personId}/preferences/{preferenceName}", this.person.getUsername(), preferenceName);
        return this.restWrapper.processModel(RestPreferenceModel.class, request);
    }

    public void removeFavoriteSite(SiteModel site) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "people/{personId}/favorite-sites/{siteId}", this.person.getUsername(), site.getId());
        this.restWrapper.processEmptyModel(request);
    }

    public RestSiteModel getFavoriteSite(SiteModel site) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/favorite-sites/{siteId}?{parameters}", this.person.getUsername(), site.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSiteModel.class, request);
    }

    public void deleteSiteMember(SiteModel site) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "people/{personId}/sites/{siteId}", this.person.getUsername(), site.getId());
        this.restWrapper.processEmptyModel(request);
    }

    public RestSiteMembershipRequestModel addSiteMembershipRequest(String siteMembershipRequest) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, siteMembershipRequest, "people/{personId}/site-membership-requests", this.person.getUsername());
        return this.restWrapper.processModel(RestSiteMembershipRequestModel.class, request);
    }

    public RestSiteMembershipRequestModel addSiteMembershipRequest(SiteModel siteModel) {
        String json = JsonBodyGenerator.siteMemberhipRequest("Please accept me", siteModel, "New request");
        return this.addSiteMembershipRequest(json);
    }

    public RestSiteMembershipRequestModel addSiteMembershipRequest(String message, SiteModel siteModel, String title) {
        String json = JsonBodyGenerator.siteMemberhipRequest(message, siteModel, title);
        return this.addSiteMembershipRequest(json);
    }

    public RestSiteMembershipModelsCollection getSitesMembershipInformation() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/sites?{parameters}", this.person.getUsername(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestSiteMembershipModelsCollection.class, request);
    }

    public RestSiteEntry getSiteMembership(SiteModel site) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/sites/{siteId}?{parameters}", this.person.getUsername(), site.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSiteEntry.class, request);
    }

    public RestSiteMembershipRequestModel getSiteMembershipRequest(SiteModel site) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/site-membership-requests/{siteId}?{parameters}", this.person.getUsername(), site.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSiteMembershipRequestModel.class, request);
    }

    public void deleteSiteMembershipRequest(SiteModel site) throws JsonToModelConversionException, EmptyJsonResponseException {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "people/{personId}/site-membership-requests/{siteId}", this.person.getUsername(), site.getId());
        this.restWrapper.processEmptyModel(request);
    }

    public RestSiteMembershipRequestModel updateSiteMembershipRequest(SiteModel siteModel, String message) {
        String json = JsonBodyGenerator.siteMemberhipRequest(message, siteModel, "New request");
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, json, "people/{personId}/site-membership-requests/{siteId}", this.person.getUsername(), siteModel.getId());
        return this.restWrapper.processModel(RestSiteMembershipRequestModel.class, request);
    }

    public RestPersonFavoritesModel getFavorite(String favoriteId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/favorites/{favoriteId}?{parameters}", this.person.getUsername(), favoriteId, this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestPersonFavoritesModel.class, request);
    }

    public RestPersonFavoritesModelsCollection getFavorites() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/favorites?{parameters}", this.person.getUsername(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestPersonFavoritesModelsCollection.class, request);
    }

    public RestPersonFavoritesModel addFolderToFavorites(FolderModel folderModel) {
        String jsonPost = JsonBodyGenerator.targetFolderWithGuid(folderModel);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, jsonPost, "people/{personId}/favorites?{parameters}", this.person.getUsername(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestPersonFavoritesModel.class, request);
    }

    public RestPersonFavoritesModel addFileToFavorites(FileModel fileModel) {
        String jsonPost = JsonBodyGenerator.targetFileWithGuid(fileModel);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, jsonPost, "people/{personId}/favorites?{parameters}", this.person.getUsername(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestPersonFavoritesModel.class, request);
    }

    public RestPersonFavoritesModel addSiteToFavorites(SiteModel siteModel) {
        String jsonPost = JsonBodyGenerator.targetSiteWithGuid(siteModel);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, jsonPost, "people/{personId}/favorites?{parameters}", this.person.getUsername(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestPersonFavoritesModel.class, request);
    }

    public RestWrapper deleteSiteFromFavorites(SiteModel site) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "people/{personId}/favorites/{favoriteId}", this.person.getUsername(), site.getGuid());
        this.restWrapper.processEmptyModel(request);
        return this.restWrapper;
    }

    public RestWrapper deleteFolderFromFavorites(FolderModel folderModel) {
        String jsonPost = JsonBodyGenerator.targetFolderWithGuid(folderModel);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.DELETE, jsonPost, "people/{personId}/favorites/{favoriteId}", this.person.getUsername(), folderModel.getNodeRef());
        this.restWrapper.processEmptyModel(request);
        return this.restWrapper;
    }

    public RestWrapper deleteFileFromFavorites(FileModel fileModel) {
        String jsonPost = JsonBodyGenerator.targetFileWithGuid(fileModel);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.DELETE, jsonPost, "people/{personId}/favorites/{favoriteId}", this.person.getUsername(), fileModel.getNodeRef());
        this.restWrapper.processEmptyModel(request);
        return this.restWrapper;
    }

    public RestNetworkModel getNetwork() {
        return this.getNetwork(this.person);
    }

    public RestNetworkModel getNetwork(UserModel tenant) {
        Utility.checkObjectIsInitialized((Object)tenant.getDomain(), (String)"tenant.getDomain()");
        String personId = tenant.getUsername().contains("-me-@") ? "-me-" : tenant.getUsername();
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/networks/{networkId}?{parameters}", personId, tenant.getDomain(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestNetworkModel.class, request);
    }

    public RestNetworkModelsCollection getNetworks() {
        return this.getNetworks(this.person);
    }

    public RestNetworkModelsCollection getNetworks(UserModel tenant) {
        String personId = tenant.getUsername().contains("-me-@") ? "-me-" : tenant.getUsername();
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/networks?{parameters}", personId, this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestNetworkModelsCollection.class, request);
    }

    public RestPersonModel createPerson(RestPersonModel newPerson) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, newPerson.toJson(), "people", new String[0]);
        return this.restWrapper.processModel(RestPersonModel.class, request);
    }

    public RestResponse downloadAvatarContent() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/avatar?{parameters}", this.person.getUsername(), this.restWrapper.getParameters());
        return this.restWrapper.process(request);
    }

    public void resetAvatarImageRequest() throws JsonToModelConversionException, EmptyJsonResponseException {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "people/{personId}/avatar", this.person.getUsername());
        this.restWrapper.processEmptyModel(request);
    }

    public void deauthorizeUser() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.POST, "people/{personId}/deauthorize", this.person.getUsername(), this.restWrapper.getParameters());
        this.restWrapper.processEmptyModel(request);
    }

    public void reauthorizeUser(RestAuthKeyModel authKey) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, authKey.toJson(), "people/{personId}/reauthorize", this.person.getUsername());
        this.restWrapper.processEmptyModel(request);
    }

    public RestAuthCodeModel getReauthorizationCode() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.POST, "people/{personId}/reauthorization-code", this.person.getUsername());
        try {
            return this.restWrapper.processModel(RestAuthCodeModel.class, request);
        }
        catch (EmptyJsonResponseException | JsonToModelConversionException e) {
            return null;
        }
    }

    public ValidatableResponse uploadAvatarContent(String fullServerUrL, File avatarFile) {
        return (ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(this.person.getUsername(), this.person.getPassword()).contentType(ContentType.BINARY).body(avatarFile).when().put(String.format("%s/%s/people/%s/avatar", fullServerUrL, RestAssured.basePath, this.person.getUsername()), new Object[0])).then();
    }

    public RestGroupsModelsCollection listGroupMemberships() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "people/{personId}/groups?{parameters}", this.person.getUsername(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestGroupsModelsCollection.class, request);
    }

    public WhereClause where() {
        return new WhereClause(this);
    }

    public class WhereClause {
        String whereClause = "where=(%s))";
        StringBuilder expression = new StringBuilder();
        private People people;

        public WhereClause(People people) {
            this.people = people;
        }

        public WhereClause targetFileExist() {
            this.expression.append("EXISTS(target/file)").append(" ");
            return this;
        }

        public WhereClause targetFolderExist() {
            this.expression.append("EXISTS(target/folder)").append(" ");
            return this;
        }

        public WhereClause targetSiteExist() {
            this.expression.append(" EXISTS(target/site)").append(" ");
            return this;
        }

        public WhereClause invalidWhereParameter(String invalidParameter) {
            this.expression.append(invalidParameter).append(" ");
            return this;
        }

        public WhereClause or() {
            this.expression.append("OR").append(" ");
            return this;
        }

        public RestPersonFavoritesModelsCollection getFavorites() {
            People.this.restWrapper.withParams(String.format(this.whereClause, this.expression));
            return this.people.getFavorites();
        }
    }
}

