/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource;

import java.util.Map;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.repo.resource.ResourceManager;
import org.alfresco.rest.repo.resource.cache.MultiKeyResourceMap;
import org.alfresco.rest.repo.resource.category.RepoCategoryCreator;
import org.alfresco.rest.repo.resource.category.RepoCategoryModifier;
import org.alfresco.rest.repo.resource.general.Modifier;
import org.alfresco.rest.repo.resource.general.Specifier;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.UserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class Categories
implements ResourceManager<RestCategoryModel, Specifier.CategoriesSpecifier, Modifier.CategoryModifier> {
    public static final String CATEGORY_NAME_PREFIX = "category";
    private static final String ROOT_CATEGORY_ID = "-root-";
    public static final RestCategoryModel ROOT_CATEGORY = RestCategoryModel.builder().id("-root-").create();
    private final RestWrapper restClient;
    private final UserModel user;
    private final Map<String, RestCategoryModel> categoriesCache = new MultiKeyResourceMap<RestCategoryModel>(RestCategoryModel::getId, RestCategoryModel::getName);

    public Categories(RestWrapper restClient, UserModel user) {
        this.restClient = restClient;
        this.user = user;
    }

    @Autowired
    public Categories(RestWrapper restClient, DataUser dataUser) {
        this(restClient, dataUser.getAdminUser());
    }

    @Override
    public Specifier.CategoriesSpecifier add() {
        return (Specifier.CategoriesSpecifier)new RepoCategoryCreator(this.restClient, this.categoriesCache).underCategory(ROOT_CATEGORY).asUser(this.user);
    }

    @Override
    public RestCategoryModel get(String key) {
        return this.categoriesCache.get(key);
    }

    @Override
    public Modifier.CategoryModifier modify(RestCategoryModel category) {
        return (Modifier.CategoryModifier)new RepoCategoryModifier(this.restClient, category, this.categoriesCache).asUser(this.user);
    }

    @Override
    public void delete(RestCategoryModel category) {
        ((Modifier.CategoryModifier)new RepoCategoryModifier(this.restClient, category, this.categoriesCache).asUser(this.user)).delete();
    }
}

