/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSitesMembershipInformationCoreTests
extends RestTest {
    private SiteModel publicSiteModel;
    private SiteModel moderatedSiteModel;
    private SiteModel privateSiteModel;
    private UserModel userModel;
    UserModel leaveSiteUserModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.userModel = this.dataUser.createRandomTestUser();
        this.leaveSiteUserModel = this.dataUser.createRandomTestUser();
        this.publicSiteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.moderatedSiteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createModeratedRandomSite();
        this.privateSiteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPrivateRandomSite();
        this.dataUser.addUserToSite(this.leaveSiteUserModel, this.publicSiteModel, UserRole.SiteCollaborator);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to retrieve site membership information for a personId that does not exist")
    public void siteManagerCantRetrieveSiteMembershipInformationForAPersonIdThatDoesNotExist() throws Exception {
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(new UserModel("invalidPersonId", "password")).getSitesMembershipInformation().assertThat().entriesListIsEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.restClient.assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidPersonId")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site membership information request returns status code 400 when invalid maxItems parameter is used")
    public void getSiteMembershipInformationRequestReturns400ForInvalidMaxItemsParameter() throws Exception {
        this.restClient.authenticateUser(this.userModel).withParams(new String[]{"maxItems=0"}).withCoreAPI().usingAuthUser().getSitesMembershipInformation().assertThat().entriesListIsEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS);
        this.restClient.withParams(new String[]{"maxItems=-1"}).withCoreAPI().usingAuthUser().getSitesMembershipInformation().assertThat().entriesListIsEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS);
        this.restClient.withParams(new String[]{"maxItems=test"}).withCoreAPI().usingAuthUser().getSitesMembershipInformation().assertThat().entriesListIsEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "test"));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site membership information request returns status code 200 for valid maxItems parameter")
    public void getSiteMembershipInformationRequestReturns200ForValidMaxItemsParameter() throws Exception {
        ((RestModels)this.restClient.authenticateUser(this.userModel).withParams(new String[]{"maxItems=5"}).withCoreAPI().usingAuthUser().getSitesMembershipInformation().assertThat().entriesListIsNotEmpty()).getPagination().assertThat().field("maxItems").is((Object)"5");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site membership information request returns status code 400 when invalid skipCount parameter is used")
    public void getSiteMembershipInformationRequestReturns400ForInvalidSkipCountParameter() throws Exception {
        this.restClient.authenticateUser(this.userModel).withParams(new String[]{"skipCount=-1"}).withCoreAPI().usingAuthUser().getSitesMembershipInformation().assertThat().entriesListIsEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT);
        this.restClient.withParams(new String[]{"skipCount=test"}).withCoreAPI().usingAuthUser().getSitesMembershipInformation().assertThat().entriesListIsEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsErrorKey(String.format(RestErrorModel.INVALID_SKIPCOUNT, "test")).containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "test")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site membership information request returns status code 200 for valid skipCount parameter")
    public void getSiteMembershipInformationRequestReturns200ForValidSkipCountParameter() throws Exception {
        ((RestModels)this.restClient.authenticateUser(this.userModel).withParams(new String[]{"skipCount=1"}).withCoreAPI().usingAuthUser().getSitesMembershipInformation().assertThat().entriesListIsNotEmpty()).getPagination().assertThat().field("skipCount").is((Object)"1");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to retrieve public sites")
    public void siteManagerCheckThatPublicSitesAreRetrieved() throws Exception {
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingAuthUser().getSitesMembershipInformation().assertThat().entriesListContains("id", this.publicSiteModel.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to retrieve moderated sites")
    public void siteManagerCheckThatModeratedSitesAreRetrieved() throws Exception {
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingAuthUser().getSitesMembershipInformation().assertThat().entriesListContains("id", this.moderatedSiteModel.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to retrieve private sites")
    public void siteManagerCheckThatPrivateSitesAreRetrieved() throws Exception {
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingAuthUser().getSitesMembershipInformation().assertThat().entriesListContains("id", this.privateSiteModel.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site member is able to leave site")
    public void siteMemberIsAbleToLeaveSite() throws Exception {
        this.restClient.authenticateUser(this.leaveSiteUserModel).withCoreAPI().usingAuthUser().deleteSiteMember(this.publicSiteModel);
        this.restClient.authenticateUser(this.leaveSiteUserModel).withCoreAPI().usingAuthUser().getSitesMembershipInformation().assertThat().entriesListIsEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }
}

