/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestItemModelsCollection;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetTaskItemsSanityTests
extends RestTest {
    private UserModel userModel;
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private SiteModel siteModel;
    private FileModel fileModel;
    private FileModel document1;
    private TaskModel taskModel;
    private RestItemModel taskItem;
    private RestItemModelsCollection itemModels;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify that user that started the process gets task items")
    public void getTaskItemsByUserWhoStartedProcess() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.document1 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document1);
        Utility.checkObjectIsInitialized((Object)this.taskItem, (String)"taskItem");
        this.itemModels = this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.itemModels.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", this.taskItem.getId())).and().entriesListContains("name", this.document1.getName());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify that involved user in process gets task items")
    public void getTaskItemsByUserInvolvedInProcess() throws Exception {
        this.restClient.authenticateUser(this.assignee);
        this.document1 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document1);
        this.itemModels = this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.itemModels.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", this.taskItem.getId())).and().entriesListContains("name", this.document1.getName());
    }
}

