/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.deployments;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestDeploymentModel;
import org.alfresco.rest.model.RestDeploymentModelsCollection;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetDeploymentFullTests
extends RestTest {
    private UserModel adminUser;
    private RestDeploymentModel expectedDeployment;
    private RestDeploymentModel actualDeployment;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
    }

    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.REGRESSION}, description="Verify if get deployment request returns all deployments if empty deploymentId is used.")
    @Test(groups={"rest-api", "workflow", "deployments", "regression"})
    public void getNonNetworkDeploymentUsingEmptyDeploymentId() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI();
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"deployments/{deploymentId}", (String[])new String[]{""});
        RestDeploymentModelsCollection deployments = (RestDeploymentModelsCollection)this.restClient.processModels(RestDeploymentModelsCollection.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        deployments.assertThat().entriesListIsNotEmpty();
    }

    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets non-network deployments with properties parameter applied using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "deployments", "regression"})
    public void getNonNetworkDeploymentsWithValidProperties() throws Exception {
        this.expectedDeployment = ((RestDeploymentModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getDeployments().getOneRandomEntry()).onModel();
        this.actualDeployment = this.restClient.withParams(new String[]{"properties=id,name"}).withWorkflowAPI().usingDeployment(this.expectedDeployment).getDeployment();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestDeploymentModel)((RestDeploymentModel)((RestDeploymentModel)this.actualDeployment.assertThat().fieldsCount().is((Object)2)).and().field("id").is((Object)this.expectedDeployment.getId())).and().field("deployedAt").isNull()).and().field("name").is((Object)this.expectedDeployment.getName());
    }
}

