/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.comments;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestCommentModelsCollection;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataLink;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.LinkModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matchers;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddCommentTests
extends RestTest {
    private UserModel adminUserModel;
    private FileModel document;
    private SiteModel siteModel;
    private DataUser.ListUserWithRoles usersWithRoles;
    private String comment;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(this.adminUserModel);
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.SANITY}, description="Verify admin user adds comments with Rest API and status code is 201")
    @Test(groups={"rest-api", "comments", "sanity"})
    public void adminIsAbleToAddComment() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        String newContent = "This is a new comment added by " + this.adminUserModel.getUsername();
        ((RestCommentModel)this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment(newContent).assertThat().field("content").isNotEmpty()).and().field("content").is((Object)newContent);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.onResponse().assertThat().body("entry.edited", Matchers.is((Object)false), new Object[0]);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.SANITY}, description="Verify that comment can be retrieved after it is added")
    @Test(groups={"rest-api", "comments", "sanity"})
    public void addCommentThenRetrieveComment() throws Exception {
        this.comment = RandomData.getRandomName((String)"comment1");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.document).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestCommentModelsCollection comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.document).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        comments.assertThat().entriesListContains("content", this.comment);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.SANITY}, description="Verify unauthenticated user gets status code 401 on post comments call")
    @Test(groups={"rest-api", "comments", "sanity"})
    public void unauthenticatedUserIsNotAbleToAddComment() throws Exception {
        this.restClient.authenticateUser(new UserModel("random user", "random password"));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment");
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user adds comments with Rest API and status code is 201")
    @Test(groups={"rest-api", "comments", "regression"})
    public void managerIsAbleToAddComment() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        String contentSiteManger = "This is a new comment added by user with role: " + String.valueOf(UserRole.SiteManager);
        RestCommentModel createdComment = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment(contentSiteManger);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestCommentModel)createdComment.assertThat().field("content").isNotEmpty()).and().field("content").is((Object)contentSiteManger);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user adds comments with Rest API and status code is 201")
    @Test(groups={"rest-api", "comments", "regression"})
    @Bug(id="ACE-4614")
    public void contributorIsAbleToAddComment() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        String contentSiteContributor = "This is a new comment added by user with role" + String.valueOf(UserRole.SiteContributor);
        RestCommentModel createdComment = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment(contentSiteContributor);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestCommentModel)createdComment.assertThat().field("content").isNotEmpty()).and().field("content").is((Object)contentSiteContributor);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user adds comments with Rest API and status code is 201")
    @Test(groups={"rest-api", "comments", "regression"})
    public void collaboratorIsAbleToAddComment() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        String contentSiteCollaborator = "This is a new comment added by user with role: " + String.valueOf(UserRole.SiteCollaborator);
        ((RestCommentModel)this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment(contentSiteCollaborator).assertThat().field("content").isNotEmpty()).and().field("content").is((Object)contentSiteCollaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Consumer user can't add comments with Rest API and status code is 403")
    @Test(groups={"rest-api", "comments", "regression"})
    public void consumerIsNotAbleToAddComment() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        String contentSiteConsumer = "This is a new comment added by user with role: " + String.valueOf(UserRole.SiteConsumer);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment(contentSiteConsumer);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify that invalid request returns status code 404 for nodeId that does not exist")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentUsingInvalidNodeId() throws Exception {
        this.comment = RandomData.getRandomName((String)"comment1");
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        file.setNodeRef(RandomStringUtils.randomAlphanumeric((int)20));
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, file.getNodeRef()));
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify that request using nodeId that is neither document or folder returns 405")
    @Bug(id="MNT-16904")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentUsingResourceThatIsNotFileOrFolder() throws Exception {
        this.comment = RandomData.getRandomName((String)"comment1");
        LinkModel link = ((DataLink)((DataLink)this.dataLink.usingAdmin()).usingSite(this.siteModel)).createRandomLink();
        FileModel fileWithNodeRefFromLink = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        fileWithNodeRefFromLink = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        fileWithNodeRefFromLink.setNodeRef(link.getNodeRef());
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)fileWithNodeRefFromLink).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify that adding comment using empty content returns 400 status code")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentUsingEmptyContent() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.document).addComment("");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NULL_ARGUMENT, "comment"));
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify adding comment with the same content as one existing comment")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentTwice() throws Exception {
        this.comment = RandomData.getRandomName((String)"comment1");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.document).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.document).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getNodeComments().assertThat().entriesListContains("content", this.comment);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify comment cannot be added if user is not member of private site")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentWithNonMemberOfPrivateSite() throws Exception {
        this.comment = RandomData.getRandomName((String)"comment1");
        UserModel member = this.dataUser.createRandomTestUser();
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPrivateRandomSite();
        FileModel file = ((DataContent)this.dataContent.usingSite(privateSite)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(member).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify comment cannot be added if empty network ID is provided")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentUsingEmptyNetworkId() throws Exception {
        this.comment = RandomData.getRandomName((String)"comment1");
        UserModel member = this.dataUser.createRandomTestUser();
        member.setDomain("");
        this.restClient.authenticateUser(member).withCoreAPI().usingResource((RepoTestModel)this.document).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify that comment cannot be added to another comment")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentToAComment() throws Exception {
        this.comment = RandomData.getRandomName((String)"comment1");
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestCommentModel commentEntry = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.comment);
        file.setNodeRef(commentEntry.getId());
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.CANNOT_COMMENT);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify that comment cannot be added to a tag")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentToATag() throws Exception {
        this.comment = RandomData.getRandomName((String)"comment1");
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestTagModel tag = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addTag("randomTag");
        file.setNodeRef(tag.getId());
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.CANNOT_COMMENT);
    }
}

