/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.categories;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.categories.CategoriesRestTest;
import org.alfresco.rest.model.RestCategoryLinkBodyModel;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.model.RestCategoryModelsCollection;
import org.alfresco.rest.requests.Categories;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CategoriesPathTests
extends CategoriesRestTest {
    private FileModel file;
    private RestCategoryModel category;

    @Override
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        Step.STEP((String)"Create user and site");
        this.user = this.dataUser.createRandomTestUser();
        SiteModel site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        Step.STEP((String)"Create a folder, file in it and a category");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(site)).createFolder();
        this.file = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)folder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.category = this.prepareCategoryUnderRoot();
        Step.STEP((String)"Wait for indexing to complete");
        Utility.sleep((int)1000, (int)60000, () -> ((Categories)this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(this.category).include(new String[]{"path"})).getCategory().assertThat().field("path").isNotNull());
    }

    @Test(groups={"rest-api"})
    public void testGetCategoryById_includePath() {
        Step.STEP((String)"Get category and verify if path is a general path for categories");
        RestCategoryModel actualCategory = ((Categories)this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(this.category).include(new String[]{"path"})).getCategory();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        actualCategory.assertThat().field("id").is((Object)this.category.getId());
        actualCategory.assertThat().field("path").is((Object)"/categories/General");
    }

    @Test(groups={"rest-api"})
    public void testGetCategories_includePath() {
        Step.STEP((String)"Get few categories and verify its paths");
        RestCategoryModel parentCategory = this.createCategoryModelWithId("-root-");
        RestCategoryModelsCollection actualCategories = ((Categories)this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(parentCategory).include(new String[]{"path"})).getCategoryChildren();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertTrue((boolean)actualCategories.getEntries().stream().map(RestCategoryModel::onModel).allMatch(cat -> cat.getPath().equals("/categories/General")));
    }

    @Test(groups={"rest-api"})
    public void testGetChildCategory_includePath() {
        Step.STEP((String)"Create parent and child categories");
        RestCategoryModel parentCategory = this.prepareCategoryUnderRoot();
        RestCategoryModel childCategory = this.prepareCategoryUnder(parentCategory);
        Step.STEP((String)"Verify path for created child categories");
        RestCategoryModelsCollection actualCategories = ((Categories)this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(parentCategory).include(new String[]{"path"})).getCategoryChildren();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        actualCategories.getEntries().stream().map(RestCategoryModel::onModel).forEach(cat -> cat.assertThat().field("path").is((Object)("/categories/General/" + parentCategory.getName())));
    }

    @Test(groups={"rest-api"})
    public void testCreateCategory_includingPath() {
        Step.STEP((String)"Create a category under root and verify if path is a general path for categories");
        String categoryName = RandomData.getRandomName((String)"Category");
        RestCategoryModel rootCategory = this.createCategoryModelWithId("-root-");
        RestCategoryModel aCategory = this.createCategoryModelWithName(categoryName);
        RestCategoryModel createdCategory = ((RestCoreAPI)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().include(new String[]{"path"})).usingCategory(rootCategory).createSingleCategory(aCategory);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        createdCategory.assertThat().field("name").is((Object)categoryName);
        createdCategory.assertThat().field("path").is((Object)"/categories/General");
    }

    @Test(groups={"rest-api"})
    public void testUpdateCategory_includePath() {
        Step.STEP((String)"Update linked category and verify if path is a general path for categories");
        String categoryNewName = RandomData.getRandomName((String)"NewCategoryName");
        RestCategoryModel fixedCategoryModel = this.createCategoryModelWithName(categoryNewName);
        RestCategoryModel updatedCategory = ((Categories)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(this.category).include(new String[]{"path"})).updateCategory(fixedCategoryModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        updatedCategory.assertThat().field("id").is((Object)this.category.getId());
        updatedCategory.assertThat().field("path").is((Object)"/categories/General");
    }

    @Test(groups={"rest-api"})
    public void testLinkNodeToCategories_includePath() {
        Step.STEP((String)"Link node to categories and verify if path is a general path");
        RestCategoryLinkBodyModel categoryLinkModel = this.createCategoryLinkModelWithId(this.category.getId());
        RestCategoryModel linkedCategory = ((Node)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingNode((RepoTestModel)this.file).include(new String[]{"path"})).linkToCategory(categoryLinkModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        linkedCategory.assertThat().field("id").is((Object)this.category.getId());
        linkedCategory.assertThat().field("path").is((Object)"/categories/General");
    }

    @Test(groups={"rest-api"})
    public void testListCategoriesForNode_includePath() {
        Step.STEP((String)"Link file to category");
        RestCategoryLinkBodyModel categoryLink = this.createCategoryLinkModelWithId(this.category.getId());
        RestCategoryModel linkedCategory = ((Node)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingNode((RepoTestModel)this.file).include(new String[]{"path"})).linkToCategory(categoryLink);
        Step.STEP((String)"Get linked category and verify if path is a general path");
        RestCategoryModelsCollection linkedCategories = ((Node)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingNode((RepoTestModel)this.file).include(new String[]{"path"})).getLinkedCategories();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        linkedCategories.assertThat().entriesListCountIs(1);
        ((RestCategoryModel)linkedCategories.getEntries().get(0)).onModel().assertThat().field("id").is((Object)this.category.getId());
        ((RestCategoryModel)linkedCategories.getEntries().get(0)).onModel().assertThat().field("path").is((Object)"/categories/General");
    }
}

