/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.model;

import io.restassured.http.Headers;
import io.restassured.response.ResponseBody;
import org.alfresco.utility.Utility;
import org.alfresco.utility.report.log.Step;
import org.testng.Assert;

public class RestHtmlResponse {
    private Headers headers;
    private ResponseBody body;

    public ResponseBody getBody() {
        return this.body;
    }

    public RestHtmlResponse(Headers headers, ResponseBody body) {
        this.headers = headers;
        this.body = body;
    }

    public void assertResponseContainsImage() {
        Step.STEP((String)"REST API: Assert that response has an image.");
        Utility.checkObjectIsInitialized((Object)this.headers, (String)"Headers");
        Utility.checkObjectIsInitialized((Object)this.body, (String)"Body");
        Assert.assertTrue((boolean)this.headers.getValue("content-type").contains("image/png"), (String)String.format("Content type is not an image. Actual content type is %s", this.headers.getValue("content-type")));
        Assert.assertNotEquals((Object)this.headers.getValue("content-length"), (Object)"0", (String)"Content length should be greater than 0 bytes.");
        Assert.assertFalse((boolean)this.body.toString().isEmpty(), (String)"Body should not be empty.");
    }

    public void assertPathInHtmlBodyEquals(String elementHtmlPath, String value) {
        Assert.assertEquals((String)((String)this.body.htmlPath().get(elementHtmlPath)), (String)value);
    }
}

