/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import java.util.List;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.model.RestCategoryModelsCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.springframework.http.HttpMethod;

public class Categories
extends ModelRequest<Categories> {
    private RestCategoryModel category;

    public Categories(RestWrapper restWrapper, RestCategoryModel category) {
        super(restWrapper);
        this.category = category;
    }

    public RestCategoryModel getCategory() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "categories/{categoryId}?{parameters}", this.category.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestCategoryModel.class, request);
    }

    public RestCategoryModelsCollection createCategoriesList(List<RestCategoryModel> restCategoryModels) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, JsonBodyGenerator.arrayToJson(restCategoryModels), "categories/{categoryId}/subcategories", this.category.getId());
        return this.restWrapper.processModels(RestCategoryModelsCollection.class, request);
    }

    public RestCategoryModel createSingleCategory(RestCategoryModel restCategoryModel) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, restCategoryModel.toJson(), "categories/{categoryId}/subcategories", this.category.getId());
        return this.restWrapper.processModel(RestCategoryModel.class, request);
    }

    public RestCategoryModelsCollection getCategoryChildren() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "categories/{categoryId}/subcategories", this.category.getId());
        return this.restWrapper.processModels(RestCategoryModelsCollection.class, request);
    }

    public RestCategoryModel updateCategory(RestCategoryModel restCategoryModel) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, restCategoryModel.toJson(), "categories/{categoryId}", this.category.getId());
        return this.restWrapper.processModel(RestCategoryModel.class, request);
    }

    public void deleteCategory() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "/categories/{categoryId}", this.category.getId());
        this.restWrapper.processEmptyModel(request);
    }
}

