/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.tasks;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.rest.model.RestTaskModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessTasksFullTests
extends RestTest {
    private FileModel document;
    private SiteModel publicSite;
    private UserModel adminUser;
    private UserModel userWhoStartsProcess;
    private UserModel assignee1;
    private UserModel assignee2;
    private UserModel assignee3;
    private ProcessModel processWithSingleTask;
    private ProcessModel processWithMultipleTasks;
    private RestTaskModelsCollection processTasks;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.assignee1 = this.dataUser.createRandomTestUser("A_1");
        this.assignee2 = this.dataUser.createRandomTestUser("B_2");
        this.assignee3 = this.dataUser.createRandomTestUser("C_3");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.userWhoStartsProcess)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsProcess).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.processWithSingleTask = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsProcess)).usingSite(this.publicSite)).usingResource((ContentModel)this.document)).createSingleReviewerTaskAndAssignTo(this.assignee1);
        this.processWithMultipleTasks = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsProcess)).usingSite(this.publicSite)).usingResource((ContentModel)this.document)).createMoreReviewersWorkflowAndAssignTo(new UserModel[]{this.assignee1, this.assignee2, this.assignee3});
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user is able to getProcessTasks even if he wasn't involved in process. Check status code is OK")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessTasksWithAdmin() throws Exception {
        this.processTasks = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().usingProcess(this.processWithSingleTask).getProcessTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.processTasks.assertThat().entriesListCountIs(1)).and().entriesListContains("assignee", this.assignee1.getUsername());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process tasks with valid skipCount parameter applied")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessTasksWithValidSkipCount() throws Exception {
        this.processTasks = this.restClient.authenticateUser(this.userWhoStartsProcess).withParams(new String[]{"orderBy=assignee ASC&skipCount=2"}).withWorkflowAPI().usingProcess(this.processWithMultipleTasks).getProcessTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.processTasks.assertThat().entriesListContains("assignee", this.assignee3.getUsername())).assertThat().entriesListDoesNotContain("assignee", this.assignee1.getUsername())).assertThat().entriesListDoesNotContain("assignee", this.assignee2.getUsername())).assertThat().entriesListCountIs(1)).assertThat().paginationField("skipCount").is("2");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process tasks with negative skipCount parameter applied")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessTasksWithNegativeSkipCount() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsProcess).withParams(new String[]{"skipCount=-2"}).withWorkflowAPI().usingProcess(this.processWithMultipleTasks).getProcessTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).containsErrorKey(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).statusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process tasks with non numeric skipCount parameter applied")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessTasksWithNonNumericSkipCount() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsProcess).withParams(new String[]{"skipCount=A"}).withWorkflowAPI().usingProcess(this.processWithMultipleTasks).getProcessTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "A"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process tasks with valid maxItems parameter applied")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessTasksWithValidMaxItems() throws Exception {
        this.processTasks = this.restClient.authenticateUser(this.userWhoStartsProcess).withParams(new String[]{"orderBy=assignee ASC&maxItems=2"}).withWorkflowAPI().usingProcess(this.processWithMultipleTasks).getProcessTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.processTasks.assertThat().entriesListDoesNotContain("assignee", this.assignee3.getUsername())).assertThat().entriesListContains("assignee", this.assignee1.getUsername())).assertThat().entriesListContains("assignee", this.assignee2.getUsername())).assertThat().entriesListCountIs(2)).assertThat().paginationField("maxItems").is("2");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process tasks with negative maxItems parameter applied")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessTasksWithNegativeMaxItems() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsProcess).withParams(new String[]{"maxItems=-2"}).withWorkflowAPI().usingProcess(this.processWithMultipleTasks).getProcessTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).statusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process tasks with non numeric maxItems parameter applied")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessTasksWithNonNumericMaxItems() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsProcess).withParams(new String[]{"maxItems=A"}).withWorkflowAPI().usingProcess(this.processWithMultipleTasks).getProcessTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "A"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify getProcessTasks with properties parameter")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessTasksWithPropertiesParameter() throws Exception {
        this.processTasks = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"properties=name,assignee,state"}).withWorkflowAPI().usingProcess(this.processWithSingleTask).getProcessTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.processTasks.assertThat().entriesListCountIs(1);
        ((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)this.processTasks.getOneRandomEntry()).onModel().assertThat().field("dueAt").isNull()).and().field("processDefinitionId").isNull()).and().field("processId").isNull()).and().field("description").isNull()).and().field("startedAt").isNull()).and().field("id").isNull()).and().field("activityDefinitionId").isNull()).and().field("priority").isNull()).and().field("formResourceKey").isNull()).and().field("name").is((Object)"Review Task")).and().field("state").is((Object)"claimed")).and().field("assignee").is((Object)this.assignee1.getUsername());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify admin gets Process Tasks ordered by assignee ascendant using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessTasksOrderedByAssignee() throws Exception {
        this.processTasks = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"orderBy=assignee"}).withWorkflowAPI().usingProcess(this.processWithMultipleTasks).getProcessTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.processTasks.assertThat().entriesListIsSortedAscBy("assignee");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify admin doesn't get Process Tasks ordered by many fields")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessTasksOrderedByMultipleFields() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"orderBy=assignee,state"}).withWorkflowAPI().usingProcess(this.processWithMultipleTasks).getProcessTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Only one order by parameter is supported");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify get all process tasks after process is deleted.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessTasksAfterDeletingProcess() throws Exception {
        ProcessModel processModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsProcess)).usingSite(this.publicSite)).usingResource((ContentModel)this.document)).createSingleReviewerTaskAndAssignTo(this.assignee1);
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().usingProcess(processModel).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.processTasks = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().usingProcess(processModel).getProcessTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.processTasks.assertThat().entriesListIsEmpty();
    }
}

