/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.requests.workflowAPI.RestWorkflowAPI;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessFullTests
extends RestTest {
    private UserModel userWhoStartsProcess;
    private UserModel assignee;
    private RestProcessModel addedProcess;
    private RestProcessModel process;
    private RestProcessDefinitionModel adhocProcessDefinition;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.addedProcess = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.High);
        this.adhocProcessDefinition = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getAllProcessDefinitions().getProcessDefinitionByKey("activitiAdhoc");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able to get the process with properties parameter applied using REST API")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessWithPropertiesParameter() throws Exception {
        this.process = ((RestWorkflowAPI)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().usingParams(new String[]{"properties=startUserId,id"})).usingProcess((ProcessModel)this.addedProcess).getProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessModel)((RestProcessModel)((RestProcessModel)this.process.assertThat().fieldsCount().is((Object)2)).and().field("startUserId").is((Object)this.addedProcess.getStartUserId())).and().field("id").is((Object)this.addedProcess.getId())).and().field("processDefinitionKey").isNull();
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able to get a process that was deleted, but it has 'deleted through REST API call' deleteReason")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getDeletedProcess() throws Exception {
        this.addedProcess = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.High);
        this.process = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().usingProcess((ProcessModel)this.addedProcess).getProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessModel)((RestProcessModel)((RestProcessModel)((RestProcessModel)((RestProcessModel)((RestProcessModel)this.process.assertThat().field("processDefinitionId").is((Object)this.adhocProcessDefinition.getId())).and().field("startUserId").is((Object)this.addedProcess.getStartUserId())).and().field("startActivityId").is((Object)"start")).and().field("startedAt").isNotEmpty()).and().field("id").is((Object)this.addedProcess.getId())).and().field("completed").is((Object)false)).and().field("processDefinitionKey").is((Object)"activitiAdhoc");
        this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().usingProcess((ProcessModel)this.addedProcess).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.process = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().usingProcess((ProcessModel)this.addedProcess).getProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessModel)((RestProcessModel)((RestProcessModel)((RestProcessModel)((RestProcessModel)((RestProcessModel)((RestProcessModel)((RestProcessModel)((RestProcessModel)this.process.assertThat().field("processDefinitionId").is((Object)this.adhocProcessDefinition.getId())).and().field("durationInMs").isNotNull()).and().field("startUserId").is((Object)this.addedProcess.getStartUserId())).and().field("startActivityId").is((Object)"start")).and().field("endedAt").isNotEmpty()).and().field("startedAt").isNotEmpty()).and().field("id").is((Object)this.addedProcess.getId())).and().field("completed").is((Object)true)).and().field("deleteReason").is((Object)"deleted through REST API call")).and().field("processDefinitionKey").is((Object)"activitiAdhoc");
        this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().assertThat().entriesListDoesNotContain("id", this.process.getId());
    }
}

