/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.categories;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.categories.CategoriesRestTest;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.model.RestCategoryModelsCollection;
import org.alfresco.rest.requests.Categories;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CategoriesCountTests
extends CategoriesRestTest {
    private RestCategoryModel categoryLinkedWithFolder;
    private RestCategoryModel categoryLinkedWithFile;
    private RestCategoryModel categoryLinkedWithBoth;
    private RestCategoryModel notLinkedCategory;

    @Override
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        Step.STEP((String)"Create user and site");
        this.user = this.dataUser.createRandomTestUser();
        SiteModel site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        Step.STEP((String)"Create a folder, file in it and few categories");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(site)).createFolder();
        FileModel file = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)folder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.categoryLinkedWithFolder = this.prepareCategoryUnderRoot();
        this.categoryLinkedWithFile = this.prepareCategoryUnderRoot();
        this.categoryLinkedWithBoth = this.prepareCategoryUnder(this.prepareCategoryUnderRoot());
        this.notLinkedCategory = this.prepareCategoryUnderRoot();
        Step.STEP((String)"Link folder and file to categories");
        this.linkContentToCategories((RepoTestModel)folder, this.categoryLinkedWithFolder, this.categoryLinkedWithBoth);
        this.linkContentToCategories((RepoTestModel)file, this.categoryLinkedWithFile, this.categoryLinkedWithBoth);
        Step.STEP((String)"Wait for indexing to complete");
        Utility.sleep((int)1000, (int)60000, () -> ((Categories)this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(this.categoryLinkedWithFolder).include(new String[]{"count"})).getCategory().assertThat().field("count").isNot((Object)0));
    }

    @Test(groups={"rest-api"})
    public void testGetCategoryById_includeCount() {
        Step.STEP((String)"Get linked category and verify if count is higher than 0");
        RestCategoryModel actualCategory = ((Categories)this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(this.categoryLinkedWithBoth).include(new String[]{"count"})).getCategory();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        actualCategory.assertThat().field("id").is((Object)this.categoryLinkedWithBoth.getId());
        actualCategory.assertThat().field("count").is((Object)2);
    }

    @Test(groups={"rest-api"})
    public void testGetCategoryById_includeCountForNonLinkedCategory() {
        Step.STEP((String)"Get non-linked category and verify if count is 0");
        RestCategoryModel actualCategory = ((Categories)this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(this.notLinkedCategory).include(new String[]{"count"})).getCategory();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        actualCategory.assertThat().field("id").is((Object)this.notLinkedCategory.getId());
        actualCategory.assertThat().field("count").is((Object)0);
    }

    @Test(groups={"rest-api"})
    public void testGetCategories_includeCount() {
        Step.STEP((String)"Get few categories and verify its counts");
        RestCategoryModel parentCategory = this.createCategoryModelWithId("-root-");
        RestCategoryModelsCollection actualCategories = ((Categories)this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(parentCategory).include(new String[]{"count"})).getCategoryChildren();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertTrue((boolean)actualCategories.getEntries().stream().map(RestCategoryModel::onModel).anyMatch(category -> category.getId().equals(this.categoryLinkedWithFolder.getId()) && category.getCount() == 1L));
        Assert.assertTrue((boolean)actualCategories.getEntries().stream().map(RestCategoryModel::onModel).anyMatch(category -> category.getId().equals(this.categoryLinkedWithFile.getId()) && category.getCount() == 1L));
        Assert.assertTrue((boolean)actualCategories.getEntries().stream().map(RestCategoryModel::onModel).anyMatch(category -> category.getId().equals(this.notLinkedCategory.getId()) && category.getCount() == 0L));
    }

    @Test(groups={"rest-api"})
    public void testCreateCategory_includingCount() {
        Step.STEP((String)"Create a category under root and verify if count is 0");
        String categoryName = RandomData.getRandomName((String)"Category");
        RestCategoryModel rootCategory = this.createCategoryModelWithId("-root-");
        RestCategoryModel aCategory = this.createCategoryModelWithName(categoryName);
        RestCategoryModel createdCategory = ((RestCoreAPI)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().include(new String[]{"count"})).usingCategory(rootCategory).createSingleCategory(aCategory);
        Step.STEP((String)"Create a category under root category (as admin)");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        createdCategory.assertThat().field("name").is((Object)categoryName);
        createdCategory.assertThat().field("count").is((Object)0);
    }

    @Test(groups={"rest-api"})
    public void testUpdateCategory_includeCount() {
        Step.STEP((String)"Update linked category and verify if count is higher than 0");
        String categoryNewName = RandomData.getRandomName((String)"NewCategoryName");
        RestCategoryModel fixedCategoryModel = this.createCategoryModelWithName(categoryNewName);
        RestCategoryModel updatedCategory = ((Categories)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(this.categoryLinkedWithBoth).include(new String[]{"count"})).updateCategory(fixedCategoryModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        updatedCategory.assertThat().field("id").is((Object)this.categoryLinkedWithBoth.getId());
        updatedCategory.assertThat().field("count").is((Object)2);
    }

    @Test(groups={"rest-api"})
    public void testUpdateCategory_includeCountForNonLinkedCategory() {
        Step.STEP((String)"Update non-linked category and verify if count is 0");
        String categoryNewName = RandomData.getRandomName((String)"NewCategoryName");
        RestCategoryModel fixedCategoryModel = this.createCategoryModelWithName(categoryNewName);
        RestCategoryModel updatedCategory = ((Categories)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(this.notLinkedCategory).include(new String[]{"count"})).updateCategory(fixedCategoryModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        updatedCategory.assertThat().field("id").is((Object)this.notLinkedCategory.getId());
        updatedCategory.assertThat().field("count").is((Object)0);
    }
}

