/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people;

import io.restassured.response.ValidatableResponse;
import java.io.File;
import org.alfresco.rest.RestTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AvatarPeopleSanityTest
extends RestTest {
    private UserModel userModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.userModel = this.dataUser.createRandomTestUser();
    }

    @Test(groups={"rest-api", "people", "sanity", "renditions"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Update Avatar for People")
    public void updateGetAvatarForPeople() throws Exception {
        File avatarFile = Utility.getResourceTestDataFile((String)"avatar.jpg");
        this.restClient.authenticateUser(this.userModel);
        ValidatableResponse response = (ValidatableResponse)this.restClient.withCoreAPI().usingAuthUser().uploadAvatarContent(this.restProperties.envProperty().getFullServerUrl(), avatarFile).statusCode(200);
        Utility.sleep((int)500, (int)60000, () -> {
            this.restClient.authenticateUser(this.userModel).withCoreAPI().usingAuthUser().downloadAvatarContent();
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
        });
        Assert.assertNotNull((Object)response.extract().body().asByteArray());
        Assert.assertTrue((response.extract().body().asByteArray().length > 0 ? 1 : 0) != 0, (String)"Avatar Image not uploaded");
    }

    @Test(groups={"rest-api", "people", "sanity", "renditions"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Remove Avatar for People")
    public void removeGetAvatarForPeople() throws Exception {
        File avatarFile = Utility.getResourceTestDataFile((String)"avatar.jpg");
        this.restClient.authenticateUser(this.userModel);
        this.restClient.withCoreAPI().usingAuthUser().uploadAvatarContent(this.restProperties.envProperty().getFullServerUrl(), avatarFile).statusCode(200);
        this.restClient.authenticateUser(this.userModel);
        this.restClient.withCoreAPI().usingAuthUser().resetAvatarImageRequest();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingAuthUser().downloadAvatarContent();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }
}

