/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.content;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.repo.resource.content.SerialFoldersCreator;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.model.FolderModel;

public class NestedFoldersCreator
extends SerialFoldersCreator {
    public NestedFoldersCreator(DataContent dataContent, Map<String, FolderModel> folders) {
        super(dataContent, folders);
    }

    @Override
    public List<FolderModel> create() {
        this.verifyDataConsistency();
        return this.createNestedFoldersUnder(this.parent, this.names, 0);
    }

    private List<FolderModel> createNestedFoldersUnder(FolderModel parent, List<String> folderNames, int index) {
        ArrayList<FolderModel> createdFolders = new ArrayList<FolderModel>();
        folderNames.stream().findFirst().ifPresent(folderName -> {
            FolderModel createdFolder = this.createFolder((String)folderName, (String)this.getOrNull(this.titles, index), (String)this.getOrNull(this.descriptions, index), parent, (String)this.getOrNull(this.aliases, index));
            createdFolders.add(createdFolder);
            List<String> remainingNames = folderNames.stream().skip(1L).toList();
            if (!remainingNames.isEmpty()) {
                createdFolders.addAll(this.createNestedFoldersUnder(createdFolder, remainingNames, index + 1));
            }
        });
        return createdFolders;
    }
}

