/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessModelsCollection;
import org.alfresco.rest.model.RestProcessVariableCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessVariablesCoreTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private UserModel admin;
    private RestProcessModel processModel;
    private RestProcessVariableCollection variables;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.admin = this.dataUser.getAdminUser();
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsTask)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process variables using invalid process ID")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessVariablesUsingInvalidProcessId() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsTask).withParams(new String[]{"maxItems=2"}).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        RestProcessModelsCollection processes = this.restClient.authenticateUser(this.userWhoStartsTask).withParams(new String[]{"maxItems=2"}).withWorkflowAPI().getProcesses();
        this.processModel = ((RestProcessModel)((RestProcessModelsCollection)((RestModels)processes.assertThat().entriesListIsNotEmpty()).when()).getOneRandomEntry()).onModel();
        String id = RandomStringUtils.randomAlphanumeric((int)10);
        this.processModel.setId(id);
        this.variables = this.restClient.withParams(new String[]{"maxItems=2"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, id)).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Get process variables using empty process ID")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessVariablesUsingEmptyProcessId() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsTask).withParams(new String[]{"maxItems=2"}).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processModel.setId("");
        this.variables = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process then get process variables, status OK should be returned")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessVariablesForADeletedProcess() throws Exception {
        UserModel userWhoStartsTask = this.dataUser.createRandomTestUser();
        UserModel assignee = this.dataUser.createRandomTestUser();
        RestProcessModel processModel = this.restClient.authenticateUser(userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", assignee, false, CMISUtil.Priority.Normal);
        this.restClient.authenticateUser(this.admin).withWorkflowAPI().usingProcess((ProcessModel)processModel).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        RestProcessVariableCollection variables = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)processModel).getProcessVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        variables.assertThat().entriesListIsNotEmpty();
    }
}

