/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.comments;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestCommentModelsCollection;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataLink;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.LinkModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class UpdateCommentTests
extends RestTest {
    private UserModel adminUserModel;
    private UserModel networkUserModel;
    private FileModel document;
    private SiteModel siteModel;
    private RestCommentModel commentModel;
    private RestCommentModel returnedCommentModel;
    private RestCommentModelsCollection comments;
    private DataUser.ListUserWithRoles usersWithRoles;
    private String firstComment = "This is a new comment";
    private String updatedComment = "This is the updated comment";

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(this.adminUserModel);
        this.networkUserModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.SANITY}, description="Verify Admin user updates comments and status code is 200")
    @Test(groups={"rest-api", "comments", "sanity"})
    public void adminIsAbleToUpdateHisComment() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment added by admin");
        String updatedContent = "This is the updated comment with admin user";
        ((RestCommentModel)this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).updateComment(this.commentModel, updatedContent).assertThat().field("content").isNotEmpty()).and().field("content").is((Object)updatedContent);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.SANITY}, description="Verify unauthenticated user gets status code 401 on update comment call")
    @Test(groups={"rest-api", "comments", "sanity"})
    public void unauthenticatedUserIsNotAbleToUpdateComment() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("To be updated by unauthenticated user.");
        UserModel incorrectUserModel = new UserModel("userName", "password");
        this.restClient.authenticateUser(incorrectUserModel).withCoreAPI().usingResource((RepoTestModel)this.document).updateComment(this.commentModel, "try to update");
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.SANITY}, description="Verify entry content in response")
    @Test(groups={"rest-api", "comments", "sanity"})
    public void checkEntryContentInResponse() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment added by admin");
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).updateComment(this.commentModel, "This is the updated comment with admin user");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.commentModel.assertThat().field("content").is((Object)"This is the updated comment with admin user");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user updates comments created by admin user and status code is 200")
    @Test(groups={"rest-api", "comments", "regression"})
    public void managerIsAbleToUpdateHisComment() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment added by manager");
        ((RestCommentModel)((RestCommentModel)this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).updateComment(this.commentModel, "This is the updated comment with Manager user").and().field("content").is((Object)"This is the updated comment with Manager user")).and().field("canEdit").is((Object)true)).and().field("canDelete").is((Object)true);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user can update his own comment and status code is 200")
    @Test(groups={"rest-api", "comments", "regression"})
    public void contributorIsAbleToUpdateHisComment() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment added by contributor");
        String updatedContent = "This is the updated comment with Contributor user";
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).updateComment(this.commentModel, updatedContent);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Consumer user can not update comments created by admin user and status code is 403")
    @Test(groups={"rest-api", "comments", "regression"})
    public void consumerIsNotAbleToUpdateComment() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment added by admin");
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).updateComment(this.commentModel, "This is the updated comment with Consumer user");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user can update his own comment and status code is 200")
    @Test(groups={"rest-api", "comments", "regression"})
    public void collaboratorIsAbleToUpdateHisComment() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment added by collaborator");
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).updateComment(this.commentModel, "This is the updated comment with Collaborator user");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user can not update comments of another user and status code is 200")
    @Test(groups={"rest-api", "comments", "regression"})
    public void collaboratorIsNotAbleToUpdateCommentOfAnotherUser() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment added by admin");
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)this.document).updateComment(this.commentModel, "This is the updated comment with Collaborator user");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify update comment with inexistent nodeId returns status code 404")
    @Test(groups={"rest-api", "comments", "regression"})
    public void canNotUpdateCommentIfNodeIdIsNotSet() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        FolderModel content = FolderModel.getRandomFolderModel();
        content.setNodeRef("node ref that does not exist");
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment");
        this.restClient.withCoreAPI().usingResource((RepoTestModel)content).updateComment(this.commentModel, "This is the updated comment.");
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary("node ref that does not exist was not found");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify if commentId is not set the status code is 404")
    @Test(groups={"rest-api", "comments", "regression"})
    public void canNotUpdateCommentIfCommentIdIsNotSet() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        RestCommentModel comment = new RestCommentModel();
        String id = "comment id that does not exist";
        comment.setId(id);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).updateComment(comment, "This is the updated comment.");
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, id));
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify can not update comment if NodeId is neither document or folder and returns status code 405")
    @Test(groups={"rest-api", "comments", "regression"})
    public void canNotUpdateCommentIfNodeIdIsNeitherDocumentOrFolder() throws Exception {
        FileModel content = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        content = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUserModel);
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)content).addComment("This is a new comment");
        LinkModel link = ((DataLink)((DataLink)this.dataLink.usingAdmin()).usingSite(this.siteModel)).createRandomLink();
        content.setNodeRef(link.getNodeRef().replace("workspace://SpacesStore/", "workspace%3A%2F%2FSpacesStore%2F"));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)content).updateComment(this.commentModel, "This is the updated comment.");
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, content.getNodeRef())).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user is not able to update with empty comment body and status code is 400")
    @Test(groups={"rest-api", "comments", "regression"})
    public void adminIsNotAbleToUpdateWithEmptyCommentBody() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment added by admin");
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).updateComment(this.commentModel, "");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("An invalid argument was received");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify updated comment by Manager is listed when calling getComments and status code is 200")
    @Test(groups={"rest-api", "comments", "regression"})
    public void updatedCommentByManagerIsListed() throws Exception {
        this.commentModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment added by collaborator");
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)this.document).updateComment(this.commentModel, "This is the updated comment with Manager user");
        this.comments = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListContains("content", "This is the updated comment with Manager user");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user can update a comment with a large string")
    @Test(groups={"rest-api", "comments", "regression"})
    public void managerIsAbleToUpdateACommentWithALargeString() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String longString = RandomStringUtils.randomAlphanumeric((int)10000);
        this.commentModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.firstComment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.returnedCommentModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)file).updateComment(this.commentModel, longString);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedCommentModel.assertThat().field("content").is((Object)longString);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user can update a comment with a short string")
    @Test(groups={"rest-api", "comments", "regression"})
    public void managerIsAbleToUpdateACommentWithAShortString() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String shortString = RandomStringUtils.randomAlphanumeric((int)2);
        this.commentModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.firstComment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.returnedCommentModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)file).updateComment(this.commentModel, shortString);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedCommentModel.assertThat().field("content").is((Object)shortString);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user can update a comment with special characters")
    @Test(groups={"rest-api", "comments", "regression"})
    public void collaboratorIsAbleToUpdateACommentThatContainsSpecialChars() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String specialChars = "!@#$%^&*()'\".,<>-_+=|\\";
        this.commentModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.firstComment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.returnedCommentModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)file).updateComment(this.commentModel, specialChars);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedCommentModel.assertThat().field("content").is((Object)specialChars);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Check that you cannot update comment with Consumer then call getComments and check new comment is not listed")
    @Test(groups={"rest-api", "comments", "regression"})
    public void cannotUpdateCommentWithConsumerCallGetComments() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.firstComment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingResource((RepoTestModel)file).updateComment(this.commentModel, this.updatedComment);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.comments.assertThat().entriesListContains("content", this.firstComment)).and().entriesListDoesNotContain("content", this.updatedComment)).and().paginationField("totalItems").is("1");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Update comment with Contributor then call getComments and check new comment is listed")
    @Test(groups={"rest-api", "comments", "regression"})
    @Bug(id="ACE-4614")
    public void updateCommentWithContributorCallGetComments() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.firstComment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingResource((RepoTestModel)file).updateComment(this.commentModel, this.updatedComment);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.comments.assertThat().entriesListContains("content", this.updatedComment)).and().entriesListDoesNotContain("content", this.firstComment)).and().paginationField("totalItems").is("1");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Update comment with Collaborator then call getComments and check new comment is listed")
    @Test(groups={"rest-api", "comments", "regression"})
    public void updateCommentWithCollaboratorCallGetComments() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.firstComment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)file).updateComment(this.commentModel, this.updatedComment);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.comments.assertThat().entriesListContains("content", this.updatedComment)).and().entriesListDoesNotContain("content", this.firstComment)).and().paginationField("totalItems").is("1");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Update comment with Manager then check modified by information in response")
    @Test(groups={"rest-api", "comments", "regression"})
    public void updateCommentWithManagerCheckModifiedBy() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        UserModel manager = this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        this.commentModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.firstComment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.returnedCommentModel = this.restClient.authenticateUser(manager).withCoreAPI().usingResource((RepoTestModel)file).updateComment(this.commentModel, this.updatedComment);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestCommentModel)this.returnedCommentModel.assertThat().field("modifiedBy.id").is((Object)manager.getUsername())).and().field("content").is((Object)this.updatedComment);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Delete comment with Admin then try to update it")
    @Test(groups={"rest-api", "comments", "regression"})
    public void deleteCommentThenTryToUpdateIt() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.firstComment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)file).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)file).updateComment(this.commentModel, this.updatedComment);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user can update a comment with multi byte content")
    @Test(groups={"rest-api", "comments", "regression"})
    public void managerIsAbleToUpdateACommentWithMultiByteContent() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String multiByte = "\ufeff\u6768\u6728\u91d1";
        this.commentModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.firstComment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.returnedCommentModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)file).updateComment(this.commentModel, multiByte);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedCommentModel.assertThat().field("content").is((Object)multiByte);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user can update a comment with properties parameter")
    @Test(groups={"rest-api", "comments", "regression"})
    public void adminIsAbleToUpdateACommentWithPropertiesParameter() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.firstComment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        UserModel manager = this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        this.returnedCommentModel = this.restClient.authenticateUser(manager).withParams(new String[]{"properties=createdBy,modifiedBy,canEdit,canDelete"}).withCoreAPI().usingResource((RepoTestModel)file).updateComment(this.commentModel, this.updatedComment);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestCommentModel)((RestCommentModel)this.returnedCommentModel.assertThat().field("createdBy.id").is((Object)this.adminUserModel.getUsername())).assertThat().field("modifiedBy.id").is((Object)manager.getUsername())).assertThat().fieldsCount().is((Object)4);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Update comment with invalid node")
    @Test(groups={"rest-api", "comments", "regression"})
    public void updateCommentUsingInvalidNodeId() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.firstComment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        file.setNodeRef(RandomStringUtils.randomAlphanumeric((int)20));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)file).updateComment(this.commentModel, this.updatedComment);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, file.getNodeRef()));
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify update comment from node with invalid network id returns status code 401")
    @Test(groups={"rest-api", "comments", "regression"})
    public void updateCommentWithInvalidNetworkId() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.firstComment);
        this.networkUserModel.setDomain("invalidNetwork");
        this.restClient.authenticateUser(this.networkUserModel).withCoreAPI().usingResource((RepoTestModel)file).updateComment(this.commentModel, this.updatedComment);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify User can not update comment to a not joined private site. Status code returned is 403")
    @Test(groups={"rest-api", "comments", "regression"})
    public void userCanNotUpdateCommentToANotJoinedPrivateSiteDefaultErrorModelSchema() throws Exception {
        UserModel newUser = this.dataUser.createRandomTestUser();
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.firstComment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(newUser).withCoreAPI().usingResource((RepoTestModel)file).updateComment(this.commentModel, this.updatedComment);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY);
    }
}

