/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteProcessVariableFullTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private RestProcessModel restProcessModel;
    private ProcessModel processModel;
    private RestProcessVariableModel variableModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsTask)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.processModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createSingleReviewerTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete empty process variable")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteEmptyProcessVariable() throws Exception {
        this.variableModel = new RestProcessVariableModel("", "", "bpm:workflowPackage");
        this.restProcessModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).deleteProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.DELETE_EMPTY_ARGUMENT).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).containsErrorKey(RestErrorModel.DELETE_EMPTY_ARGUMENT).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process then delete process variables, status OK should be returned")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessVariablesForADeletedProcess() throws Exception {
        UserModel userWhoStartsTask = this.dataUser.createRandomTestUser();
        UserModel assignee = this.dataUser.createRandomTestUser();
        RestProcessModel processModel = this.restClient.authenticateUser(userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", assignee, false, CMISUtil.Priority.Normal);
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.restProcessModel = this.restClient.authenticateUser(userWhoStartsTask).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(processModel.getId());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(userWhoStartsTask).withWorkflowAPI().usingProcess((ProcessModel)processModel).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)processModel).deleteProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, processModel.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process variable using by the user who started the process.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessVariableByUserThatStartedTheProcess() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restProcessModel = this.restClient.withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).deleteProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).getProcessVariables().assertThat().entriesListDoesNotContain("name", this.variableModel.getName());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process variable using by the user involved in the process.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessVariableByUserInvolvedInTheProcess() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restProcessModel = this.restClient.withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess(this.processModel).deleteProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).getProcessVariables().assertThat().entriesListDoesNotContain("name", this.variableModel.getName());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process variable with invalid type")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessVariableInvalidType() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.restProcessModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.variableModel.setType("invalid-type");
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).deleteProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).getProcessVariables().assertThat().entriesListDoesNotContain("name", this.variableModel.getName());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process variable by non assigned user")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessVarialbleByNonAssignedUser() throws Exception {
        UserModel nonAssigned = this.dataUser.createRandomTestUser();
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.restProcessModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(nonAssigned).withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).deleteProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(String.format(RestErrorModel.ACCESS_INFORMATION_NOT_ALLOWED, this.processModel.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).containsErrorKey(String.format(RestErrorModel.ACCESS_INFORMATION_NOT_ALLOWED, this.processModel.getId())).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process variable by inexistent user")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessVarialbleByInexistentUser() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", this.userWhoStartsTask, false, CMISUtil.Priority.Normal);
        this.restProcessModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(UserModel.getRandomUserModel()).withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).deleteProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }
}

